/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar.dialect.mysql;

import java.util.Map;
import net.hasor.db.orm.Paginator;
import net.hasor.db.orm.ar.SQLBuilder;
import net.hasor.db.orm.ar.dialect.AbstractSQLBuilder;
import net.hasor.db.orm.ar.dialect.ArrayBuilderData;
import net.hasor.db.orm.ar.dialect.Dialect;
import net.hasor.db.orm.ar.dialect.MapBuilderData;

public class MySqlBuilder
extends AbstractSQLBuilder {
    @Override
    protected void fillDialect(Map<Dialect, String> dialectData) {
        dialectData.put(Dialect.AND, " and ");
        dialectData.put(Dialect.EQ, " = ");
        dialectData.put(Dialect.IS, " is ");
        dialectData.put(Dialect.DELETE, "delete");
        dialectData.put(Dialect.INSERT, "insert into");
        dialectData.put(Dialect.UPDATE, "update");
        dialectData.put(Dialect.SELECT, "select");
        dialectData.put(Dialect.FROM, " from ");
        dialectData.put(Dialect.SET, " set ");
        dialectData.put(Dialect.WHERE, " where ");
        dialectData.put(Dialect.VALUES, " values ");
        dialectData.put(Dialect.AS, " as ");
        dialectData.put(Dialect.ORDER_BY, " order by ");
        dialectData.put(Dialect.SEPARATOR, ",");
        dialectData.put(Dialect.SPACE, " ");
        dialectData.put(Dialect.LEFT_ANGLE, " (");
        dialectData.put(Dialect.RIGHT_ANGLE, ") ");
        dialectData.put(Dialect.LEFT_QUOTE, " `");
        dialectData.put(Dialect.RIGHT_QUOTE, "` ");
        dialectData.put(Dialect.LEFT_TABLE_QUOTE, " `");
        dialectData.put(Dialect.RIGHT_TABLE_QUOTE, "` ");
        dialectData.put(Dialect.NULL, "null");
        dialectData.put(Dialect.PARAM, "?");
        dialectData.put(Dialect.ALL, "*");
        dialectData.put(Dialect.ASC, "asc");
        dialectData.put(Dialect.DESC, "desc");
        dialectData.put(Dialect.COUNT_1, " count(1) ");
    }

    @Override
    public SQLBuilder.BuilderData buildPaginator(String selectSQL, Paginator paginator, Object[] whereParams) {
        StringBuffer sqlBuffer = this.orderBySQL(selectSQL, paginator);
        if (paginator != null && paginator.isEnable()) {
            sqlBuffer.append(" limit ");
            sqlBuffer.append(paginator.getFirstItem() + "," + paginator.getPageSize());
        }
        return new ArrayBuilderData(sqlBuffer.toString(), whereParams);
    }

    @Override
    public SQLBuilder.BuilderMapData buildPaginator(String selectSQL, Paginator paginator, Map<String, ?> whereParams) {
        StringBuffer sqlBuffer = this.orderBySQL(selectSQL, paginator);
        if (paginator != null && paginator.isEnable()) {
            sqlBuffer.append(" limit ");
            sqlBuffer.append(paginator.getFirstItem() + "," + paginator.getPageSize());
        }
        return new MapBuilderData(sqlBuffer.toString(), whereParams);
    }
}

