/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar.dialect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.db.orm.Paginator;
import net.hasor.db.orm.ar.Column;
import net.hasor.db.orm.ar.SQLBuilder;
import net.hasor.db.orm.ar.Sechma;
import net.hasor.db.orm.ar.dialect.ArrayBuilderData;
import net.hasor.db.orm.ar.dialect.Dialect;
import net.hasor.db.orm.ar.dialect.MapBuilderData;
import net.hasor.db.orm.ar.dialect.Oper;
import org.more.util.BeanUtils;

public abstract class AbstractSQLBuilder
implements SQLBuilder {
    private Map<Dialect, String> dialectData = new HashMap<Dialect, String>();

    public AbstractSQLBuilder() {
        this.fillDialect(this.dialectData);
    }

    protected String dia(Dialect dia) {
        return this.dialectData.get((Object)dia);
    }

    protected abstract void fillDialect(Map<Dialect, String> var1);

    private SQLBuilder.BuilderData buildWhere(Sechma sechma, Column[] whereColumn, Object[] whereParams, Oper forOper) {
        if (whereColumn.length != whereParams.length) {
            throw new IllegalArgumentException("parameters and column ,param count no same.");
        }
        StringBuffer sqlWhere = new StringBuffer("");
        int colCount = whereColumn.length;
        ArrayList<Object> paramArray = new ArrayList<Object>(whereParams.length);
        for (int i = 0; i < colCount; ++i) {
            Column col = whereColumn[i];
            Object val = whereParams[i];
            if (Oper.Delete == forOper && !col.allowDeleteWhere() || Oper.Update == forOper && !col.allowUpdateWhere()) continue;
            boolean goContinue = false;
            if (col.isIgnoreUnset() || sechma.isIgnoreUnset()) {
                Class<?> propType = col.getBeanField().getType();
                if (propType.isPrimitive()) {
                    goContinue = BeanUtils.getDefaultValue(propType).equals(val);
                } else {
                    boolean bl = goContinue = val == null;
                }
            }
            if (goContinue) continue;
            if (i > 0) {
                sqlWhere.append(this.dia(Dialect.AND));
            }
            sqlWhere.append(this.dia(Dialect.LEFT_QUOTE) + col.getName() + this.dia(Dialect.RIGHT_QUOTE));
            if (val == null) {
                sqlWhere.append(this.dia(Dialect.IS) + this.dia(Dialect.NULL));
            } else {
                sqlWhere.append(this.dia(Dialect.EQ) + this.dia(Dialect.PARAM));
            }
            if (val == null) continue;
            paramArray.add(val);
        }
        if (sqlWhere.length() <= 1) {
            sqlWhere.append("1" + this.dia(Dialect.EQ) + "1");
        }
        return new ArrayBuilderData(sqlWhere.toString(), paramArray.toArray());
    }

    @Override
    public SQLBuilder.BuilderData buildDelete(Sechma sechma, Column[] whereColumn, Object[] whereParams) {
        SQLBuilder.BuilderData whereData = this.buildWhere(sechma, whereColumn, whereParams, Oper.Delete);
        StringBuffer deleteSQL = new StringBuffer();
        deleteSQL.append(this.dia(Dialect.DELETE));
        deleteSQL.append(this.dia(Dialect.FROM));
        deleteSQL.append(this.dia(Dialect.LEFT_TABLE_QUOTE) + sechma.getName() + this.dia(Dialect.RIGHT_TABLE_QUOTE));
        deleteSQL.append(this.dia(Dialect.WHERE));
        deleteSQL.append(whereData.getSQL());
        return new ArrayBuilderData(deleteSQL.toString(), whereData.getData());
    }

    @Override
    public SQLBuilder.BuilderData buildSelect(Sechma sechma, Column[] whereColumn, Object[] whereParams) {
        StringBuffer sqlSelect = new StringBuffer("");
        sqlSelect.append(this.dia(Dialect.SELECT));
        Column[] allColumn = sechma.getColumns();
        for (int i = 0; i < allColumn.length; ++i) {
            if (i > 0) {
                sqlSelect.append(this.dia(Dialect.SEPARATOR));
            }
            sqlSelect.append(this.dia(Dialect.LEFT_QUOTE) + allColumn[i].getName() + this.dia(Dialect.RIGHT_QUOTE));
        }
        sqlSelect.append(this.dia(Dialect.FROM));
        sqlSelect.append(this.dia(Dialect.LEFT_TABLE_QUOTE) + sechma.getName() + this.dia(Dialect.RIGHT_TABLE_QUOTE));
        SQLBuilder.BuilderData whereData = this.buildWhere(sechma, whereColumn, whereParams, Oper.Select);
        sqlSelect.append(this.dia(Dialect.WHERE) + whereData.getSQL());
        return new ArrayBuilderData(sqlSelect.toString(), whereData.getData());
    }

    @Override
    public SQLBuilder.BuilderData buildUpdate(Sechma sechma, Column[] whereColumn, Object[] whereParams, Column[] dataColumn, Object[] dataParams) {
        if (dataColumn.length != dataParams.length) {
            throw new IllegalArgumentException("parameters and column ,param count no same.");
        }
        ArrayList<Object> paramArray = new ArrayList<Object>(dataParams.length + whereParams.length);
        StringBuffer updateSet = new StringBuffer("");
        int colCount = dataColumn.length;
        for (int i = 0; i < colCount; ++i) {
            Column col = dataColumn[i];
            Object val = dataParams[i];
            if (!col.allowUpdate()) continue;
            updateSet.append(this.dia(Dialect.SEPARATOR));
            updateSet.append(this.dia(Dialect.LEFT_QUOTE) + col.getName() + this.dia(Dialect.RIGHT_QUOTE));
            updateSet.append(this.dia(Dialect.EQ));
            updateSet.append(val == null ? this.dia(Dialect.NULL) : this.dia(Dialect.PARAM));
            if (val == null) continue;
            paramArray.add(val);
        }
        if (updateSet.length() > 1) {
            updateSet.delete(0, this.dia(Dialect.SEPARATOR).length());
        }
        StringBuffer updateSQL = new StringBuffer("");
        updateSQL.append(this.dia(Dialect.UPDATE));
        updateSQL.append(this.dia(Dialect.LEFT_TABLE_QUOTE) + sechma.getName() + this.dia(Dialect.RIGHT_TABLE_QUOTE));
        updateSQL.append(this.dia(Dialect.SET));
        updateSQL.append(updateSet);
        SQLBuilder.BuilderData whereData = this.buildWhere(sechma, whereColumn, whereParams, Oper.Update);
        paramArray.addAll(Arrays.asList(whereData.getData()));
        updateSQL.append(this.dia(Dialect.WHERE));
        updateSQL.append(whereData.getSQL());
        return new ArrayBuilderData(updateSQL.toString(), paramArray.toArray());
    }

    @Override
    public SQLBuilder.BuilderData buildCount(Sechma sechma, Column[] whereColumn, Object[] whereParams) {
        SQLBuilder.BuilderData whereData = this.buildWhere(sechma, whereColumn, whereParams, Oper.Select);
        StringBuffer countSQL = new StringBuffer("");
        countSQL.append(this.dia(Dialect.SELECT));
        countSQL.append(this.dia(Dialect.COUNT_1));
        countSQL.append(this.dia(Dialect.FROM));
        countSQL.append(this.dia(Dialect.LEFT_TABLE_QUOTE) + sechma.getName() + this.dia(Dialect.RIGHT_TABLE_QUOTE));
        countSQL.append(this.dia(Dialect.WHERE));
        countSQL.append(whereData.getSQL());
        return new ArrayBuilderData(countSQL.toString(), whereData.getData());
    }

    @Override
    public SQLBuilder.BuilderData buildInsert(Sechma sechma, Column[] dataColumn, Object[] dataParams) {
        StringBuffer insertColumn = new StringBuffer("");
        StringBuffer insertValue = new StringBuffer("");
        ArrayList<Object> paramArray = new ArrayList<Object>(dataParams.length);
        int colCount = dataColumn.length;
        for (int i = 0; i < colCount; ++i) {
            Column col = dataColumn[i];
            Object val = dataParams[i];
            if (!col.allowInsert()) continue;
            insertColumn.append(this.dia(Dialect.SEPARATOR));
            insertColumn.append(this.dia(Dialect.LEFT_QUOTE) + col.getName() + this.dia(Dialect.RIGHT_QUOTE));
            insertValue.append(this.dia(Dialect.SEPARATOR));
            insertValue.append(val == null ? this.dia(Dialect.NULL) : this.dia(Dialect.PARAM));
            if (val == null) continue;
            paramArray.add(val);
        }
        if (insertColumn.length() > 1) {
            String SEPARATOR = this.dia(Dialect.SEPARATOR);
            insertColumn.delete(0, SEPARATOR.length());
            insertValue.delete(0, SEPARATOR.length());
        }
        StringBuffer insertSQL = new StringBuffer("");
        insertSQL.append(this.dia(Dialect.INSERT));
        insertSQL.append(this.dia(Dialect.LEFT_TABLE_QUOTE) + sechma.getName() + this.dia(Dialect.RIGHT_TABLE_QUOTE));
        insertSQL.append(this.dia(Dialect.LEFT_ANGLE) + insertColumn + this.dia(Dialect.RIGHT_ANGLE));
        insertSQL.append(this.dia(Dialect.VALUES));
        insertSQL.append(this.dia(Dialect.LEFT_ANGLE) + insertValue + this.dia(Dialect.RIGHT_ANGLE));
        return new ArrayBuilderData(insertSQL.toString(), paramArray.toArray());
    }

    @Override
    public SQLBuilder.BuilderData buildEmptySelect(String tableName) {
        StringBuffer selectSQL = new StringBuffer("");
        selectSQL.append(this.dia(Dialect.SELECT));
        selectSQL.append(this.dia(Dialect.SPACE) + this.dia(Dialect.ALL) + this.dia(Dialect.SPACE));
        selectSQL.append(this.dia(Dialect.FROM));
        selectSQL.append(this.dia(Dialect.LEFT_QUOTE) + tableName + this.dia(Dialect.RIGHT_QUOTE));
        selectSQL.append(this.dia(Dialect.WHERE));
        selectSQL.append("1" + this.dia(Dialect.EQ) + "2");
        return new ArrayBuilderData(selectSQL.toString(), null);
    }

    @Override
    public SQLBuilder.BuilderData buildPaginator(String selectSQL, Paginator paginator, Object[] whereParams) {
        return new ArrayBuilderData(this.orderBySQL(selectSQL, paginator).toString(), whereParams);
    }

    @Override
    public SQLBuilder.BuilderMapData buildPaginator(String selectSQL, Paginator paginator, Map<String, ?> whereParams) {
        return new MapBuilderData(this.orderBySQL(selectSQL, paginator).toString(), whereParams);
    }

    protected StringBuffer orderBySQL(String selectSQL, Paginator paginator) {
        StringBuffer pageSQL = new StringBuffer("");
        pageSQL.append(this.dia(Dialect.SELECT));
        pageSQL.append(this.dia(Dialect.SPACE) + this.dia(Dialect.ALL) + this.dia(Dialect.SPACE));
        pageSQL.append(this.dia(Dialect.FROM));
        pageSQL.append(this.dia(Dialect.LEFT_ANGLE) + selectSQL + this.dia(Dialect.RIGHT_ANGLE));
        pageSQL.append(this.dia(Dialect.AS) + "temp");
        if (paginator != null) {
            List<Paginator.Order> orderList = paginator.getOrderBy();
            StringBuffer orderSQL = new StringBuffer("");
            if (orderList != null && !orderList.isEmpty()) {
                for (int i = 0; i < orderList.size(); ++i) {
                    Paginator.Order order = orderList.get(i);
                    Paginator.Order.OrderBy orderBy = order.getOrderBy();
                    orderSQL.append(this.dia(Dialect.SEPARATOR));
                    orderSQL.append(this.dia(Dialect.LEFT_QUOTE) + order.getSortField() + this.dia(Dialect.RIGHT_QUOTE));
                    orderSQL.append(Paginator.Order.OrderBy.ASC == orderBy ? this.dia(Dialect.ASC) : this.dia(Dialect.DESC));
                }
            }
            if (orderSQL.length() > 1) {
                orderSQL.delete(0, this.dia(Dialect.SEPARATOR).length());
                orderSQL.insert(0, this.dia(Dialect.ORDER_BY));
                pageSQL.append(orderSQL);
            }
        }
        return pageSQL;
    }
}

