/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.hasor.db.orm.ar.Column;

public final class Sechma
implements Serializable {
    private static final long serialVersionUID = 8496566657601059017L;
    private String name = null;
    private boolean ignoreUnset = true;
    private Column keyColumn = null;
    private Column[] columnArray = new Column[0];
    private Map<String, Column> columnMap = new HashMap<String, Column>();

    protected Sechma(String sechmaName) {
        if (sechmaName == null) {
            throw new NullPointerException("sechmaName is null.");
        }
        this.name = sechmaName;
    }

    public boolean isIgnoreUnset() {
        return this.ignoreUnset;
    }

    protected void setIgnoreUnset(boolean ignoreUnset) {
        this.ignoreUnset = ignoreUnset;
    }

    public String getName() {
        return this.name;
    }

    public Column getPrimaryKey() {
        return this.keyColumn;
    }

    public Column getColumn(String columnName) {
        return this.columnMap.get(columnName);
    }

    public Column getColumn(int columnIndex) {
        return this.columnArray[columnIndex];
    }

    public Column[] getColumns() {
        return this.columnArray;
    }

    protected Column[] getInsertColumns() {
        ArrayList<Column> insertCols = new ArrayList<Column>();
        for (Column col : this.columnArray) {
            if (!col.allowInsert()) continue;
            insertCols.add(col);
        }
        return insertCols.toArray(new Column[insertCols.size()]);
    }

    protected Column[] getUpdateColumns() {
        ArrayList<Column> updateCols = new ArrayList<Column>();
        for (Column col : this.columnArray) {
            if (!col.allowUpdate()) continue;
            updateCols.add(col);
        }
        return updateCols.toArray(new Column[updateCols.size()]);
    }

    protected void addColumn(Column column) {
        if (column.isPrimaryKey()) {
            this.keyColumn = column;
        }
        this.columnMap.put(column.getName(), column);
        Column[] newColumnArray = new Column[this.columnArray.length + 1];
        System.arraycopy(this.columnArray, 0, newColumnArray, 0, this.columnArray.length);
        newColumnArray[newColumnArray.length - 1] = column;
        this.columnArray = newColumnArray;
    }
}

