/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import net.hasor.db.orm.ar.Column;
import net.hasor.db.orm.ar.Sechma;
import org.more.convert.ConverterUtils;
import org.more.util.BeanUtils;

public abstract class Record
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7553043036092551721L;
    private final Sechma sechma;

    public Record(Sechma sechma) {
        if (sechma == null) {
            throw new NullPointerException("sechma is null.");
        }
        this.sechma = sechma;
    }

    protected abstract Map<String, Object> getDataContainer();

    protected Sechma getSechma() {
        return this.sechma;
    }

    protected Object[] columnValues(Column[] columnArrays) {
        if (columnArrays == null) {
            return null;
        }
        Object[] arrays = new Object[columnArrays.length];
        Map<String, Object> dataContainer = this.getDataContainer();
        for (int i = 0; i < columnArrays.length; ++i) {
            arrays[i] = dataContainer.get(columnArrays[i].getName());
        }
        return arrays;
    }

    protected Column[] hasValueColumns(Column[] refColumn) {
        Sechma sechma = this.getSechma();
        if (refColumn == null) {
            refColumn = sechma.getColumns();
        }
        Set<String> dataKeys = this.getDataContainer().keySet();
        ArrayList<Column> finalColumn = new ArrayList<Column>();
        for (Column columnKey : refColumn) {
            if (!dataKeys.contains(columnKey.getName())) continue;
            finalColumn.add(columnKey);
        }
        return finalColumn.toArray(new Column[finalColumn.size()]);
    }

    public void initDefault() {
        Sechma sechma = this.getSechma();
        for (Column atCol : sechma.getColumns()) {
            if (!this.isNull(atCol.getName())) continue;
            Object colValue = atCol.getDefaultValue();
            if (!atCol.allowEmpty() && colValue == null) {
                colValue = BeanUtils.getDefaultValue(atCol.getJavaType());
                if (atCol.getJavaType() == String.class) {
                    colValue = "";
                }
            }
            if (colValue == null) continue;
            this.set(atCol, colValue);
        }
    }

    public abstract Object clone() throws CloneNotSupportedException;

    public abstract Object get(String var1);

    public Object get(int column) {
        return this.get(this.getSechma().getColumn(column).getName());
    }

    public Object get(Column column) {
        return this.get(column.getName());
    }

    public abstract Record set(String var1, Object var2);

    public Record set(int column, Object var) {
        return this.set(this.getSechma().getColumn(column).getName(), var);
    }

    public Record set(Column column, Object var) {
        return this.set(column.getName(), var);
    }

    public Record setMap(Map<String, Object> dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return this;
        }
        Sechma sechma = this.getSechma();
        for (Map.Entry<String, Object> ent : dataMap.entrySet()) {
            this.set(sechma.getColumn(ent.getKey()), ent.getValue());
        }
        return this;
    }

    public Object getID() {
        return this.get(this.getSechma().getPrimaryKey());
    }

    public Record setID(Object var) {
        return this.set(this.getSechma().getPrimaryKey(), var);
    }

    public boolean hasValue(String columnName) {
        return this.getDataContainer().containsKey(columnName);
    }

    public boolean hasColumn(String columnName) {
        return this.getSechma().getColumn(columnName) != null;
    }

    public boolean isNull(String column) {
        return this.get(column) == null;
    }

    public boolean isNull(int column) {
        return this.get(column) == null;
    }

    public char asChar(String column) {
        return this.toType(this.get(column), Character.TYPE, Character.valueOf('\u0000')).charValue();
    }

    public char asChar(String column, char defaultValue) {
        return this.toType(this.get(column), Character.TYPE, Character.valueOf(defaultValue)).charValue();
    }

    public char asChar(int column) {
        return this.toType(this.get(column), Character.TYPE, Character.valueOf('\u0000')).charValue();
    }

    public char asChar(int column, char defaultValue) {
        return this.toType(this.get(column), Character.TYPE, Character.valueOf(defaultValue)).charValue();
    }

    public String asString(String column) {
        return this.toType(this.get(column), String.class, null);
    }

    public String asString(String column, String defaultValue) {
        return this.toType(this.get(column), String.class, defaultValue);
    }

    public String asString(int column) {
        return this.toType(this.get(column), String.class, null);
    }

    public String asString(int column, String defaultValue) {
        return this.toType(this.get(column), String.class, defaultValue);
    }

    public boolean asBoolean(String column) {
        return this.toType(this.get(column), Boolean.TYPE, false);
    }

    public boolean asBoolean(String column, boolean defaultValue) {
        return this.toType(this.get(column), Boolean.TYPE, defaultValue);
    }

    public boolean asBoolean(int column) {
        return this.toType(this.get(column), Boolean.TYPE, false);
    }

    public boolean asBoolean(int column, boolean defaultValue) {
        return this.toType(this.get(column), Boolean.TYPE, defaultValue);
    }

    public short asShort(String column) {
        return this.toType(this.get(column), Short.TYPE, (short)0);
    }

    public short asShort(String column, short defaultValue) {
        return this.toType(this.get(column), Short.TYPE, defaultValue);
    }

    public short asShort(int column) {
        return this.toType(this.get(column), Short.TYPE, (short)0);
    }

    public short asShort(int column, short defaultValue) {
        return this.toType(this.get(column), Short.TYPE, defaultValue);
    }

    public int asInt(String column) {
        return this.toType(this.get(column), Integer.TYPE, 0);
    }

    public int asInt(String column, int defaultValue) {
        return this.toType(this.get(column), Integer.TYPE, defaultValue);
    }

    public int asInt(int column) {
        return this.toType(this.get(column), Integer.TYPE, 0);
    }

    public int asInt(int column, int defaultValue) {
        return this.toType(this.get(column), Integer.TYPE, defaultValue);
    }

    public long asLong(String column) {
        return this.toType(this.get(column), Long.TYPE, 0).intValue();
    }

    public long asLong(String column, long defaultValue) {
        return this.toType(this.get(column), Long.TYPE, defaultValue);
    }

    public long asLong(int column) {
        return this.toType(this.get(column), Long.TYPE, 0).intValue();
    }

    public long asLong(int column, long defaultValue) {
        return this.toType(this.get(column), Long.TYPE, defaultValue);
    }

    public float asFloat(String column) {
        return this.toType(this.get(column), Float.TYPE, 0).intValue();
    }

    public float asFloat(String column, float defaultValue) {
        return this.toType(this.get(column), Float.TYPE, Float.valueOf(defaultValue)).floatValue();
    }

    public float asFloat(int column) {
        return this.toType(this.get(column), Float.TYPE, 0).intValue();
    }

    public float asFloat(int column, float defaultValue) {
        return this.toType(this.get(column), Float.TYPE, Float.valueOf(defaultValue)).floatValue();
    }

    public double asDouble(String column) {
        return this.toType(this.get(column), Double.TYPE, 0).intValue();
    }

    public double asDouble(String column, double defaultValue) {
        return this.toType(this.get(column), Double.TYPE, defaultValue);
    }

    public double asDouble(int column) {
        return this.toType(this.get(column), Double.TYPE, 0).intValue();
    }

    public double asDouble(int column, double defaultValue) {
        return this.toType(this.get(column), Double.TYPE, defaultValue);
    }

    public Date asDate(String column) {
        return this.toType(this.get(column), Date.class, null);
    }

    public Date asDate(String column, Date defaultValue) {
        return this.toType(this.get(column), Date.class, defaultValue);
    }

    public Date asDate(String column, long defaultValue) {
        return this.toType(this.get(column), Date.class, new Date(defaultValue));
    }

    public Date asDate(String column, String format) {
        return this.asDate(column, format, null);
    }

    public Date asDate(String column, String format, Date defaultValue) {
        String oriData = this.toType(this.get(column), String.class, null);
        if (oriData == null || oriData.length() == 0) {
            return defaultValue;
        }
        return this.str2Date(oriData, format, defaultValue);
    }

    public Date asDate(String column, String format, long defaultValue) {
        return this.asDate(column, format, new Date(defaultValue));
    }

    public Date asDate(int column) {
        return this.toType(this.get(column), Date.class, null);
    }

    public Date asDate(int column, Date defaultValue) {
        return this.toType(this.get(column), Date.class, defaultValue);
    }

    public Date asDate(int column, long defaultValue) {
        return this.toType(this.get(column), Date.class, new Date(defaultValue));
    }

    public Date asDate(int column, String format) {
        return this.asDate(column, format, null);
    }

    public Date asDate(int column, String format, Date defaultValue) {
        String oriData = this.toType(this.get(column), String.class, null);
        if (oriData == null || oriData.length() == 0) {
            return defaultValue;
        }
        return this.str2Date(oriData, format, defaultValue);
    }

    public Date asDate(int column, String format, long defaultValue) {
        return this.asDate(column, format, new Date(defaultValue));
    }

    private Date str2Date(String oriData, String format, Date defaultValue) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        dateFormat.setLenient(false);
        Date parsedDate = ((DateFormat)dateFormat).parse(oriData, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != oriData.length() || parsedDate == null) {
            return defaultValue;
        }
        return parsedDate;
    }

    public <T extends Enum<?>> T asEnum(String column, Class<T> enmType) {
        return (T)((Enum)this.toType(this.get(column), enmType, null));
    }

    public <T extends Enum<?>> T asEnum(String column, Class<T> enmType, T defaultValue) {
        return this.toType(this.get(column), enmType, defaultValue);
    }

    public <T extends Enum<?>> T asEnum(int column, Class<T> enmType) {
        return (T)((Enum)this.toType(this.get(column), enmType, null));
    }

    public <T extends Enum<?>> T asEnum(int column, Class<T> enmType, T defaultValue) {
        return this.toType(this.get(column), enmType, defaultValue);
    }

    private <T> T toType(Object oriData, Class<?> toType, T defaultValue) {
        if (oriData == null) {
            return defaultValue;
        }
        return (T)ConverterUtils.convert(toType, (Object)oriData);
    }
}

