/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.core.Hasor;
import net.hasor.db.jdbc.JdbcOperations;
import net.hasor.db.jdbc.RowMapper;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.core.mapper.ColumnMapRowMapper;
import net.hasor.db.orm.PageResult;
import net.hasor.db.orm.Paginator;
import net.hasor.db.orm.ar.ArConfiguration;
import net.hasor.db.orm.ar.Column;
import net.hasor.db.orm.ar.Identify;
import net.hasor.db.orm.ar.Record;
import net.hasor.db.orm.ar.SQLBuilder;
import net.hasor.db.orm.ar.Sechma;
import net.hasor.db.orm.ar.dialect.SQLBuilderEnum;
import net.hasor.db.orm.ar.record.MapRecord;
import org.more.logger.LoggerHelper;

public final class DataBase {
    private static final Map<String, Object> Empty = new HashMap<String, Object>();
    private static final ArConfiguration arConfiguration = new ArConfiguration();
    private DataSource dataSource = null;
    private SQLBuilder sqlBuilder = null;

    public PageResult<Record> queryBySQL(String sqlQuery) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, null, null, Empty);
    }

    public PageResult<Record> queryBySQL(String sqlQuery, Object ... params) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, null, null, params);
    }

    public PageResult<Record> queryBySQL(String sqlQuery, Map<String, Object> params) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, null, null, params);
    }

    public PageResult<Record> queryBySQL(String sqlQuery, Paginator paginator) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, paginator, null, Empty);
    }

    public PageResult<Record> queryBySQL(String sqlQuery, Paginator paginator, Object ... params) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, paginator, null, params);
    }

    public PageResult<Record> queryBySQL(String sqlQuery, Paginator paginator, Map<String, Object> params) throws SQLException {
        return this.queryBySQL(Record.class, sqlQuery, paginator, null, params);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, null, this.loadSechma(recType), Empty);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Object ... params) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, null, this.loadSechma(recType), params);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Map<String, Object> params) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, null, this.loadSechma(recType), params);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Paginator paginator) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, paginator, this.loadSechma(recType), Empty);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Paginator paginator, Object ... params) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, paginator, this.loadSechma(recType), params);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Paginator paginator, Map<String, Object> params) throws SQLException {
        return this.queryBySQL(recType, sqlQuery, paginator, this.loadSechma(recType), params);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Paginator paginator, Sechma useSechma, Object ... params) throws SQLException {
        SQLBuilder builder = this.getSQLBuilder();
        SQLBuilder.BuilderData queryData = builder.buildPaginator(sqlQuery, paginator, params);
        if (recType == Record.class) {
            LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{queryData});
            List<Record> entList = this.getJdbc().query(queryData.getSQL(), queryData.getData(), this.getRecordRowMapper(useSechma));
            return new PageResult<Record>(paginator, entList);
        }
        LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{queryData});
        List<T> entList = this.getJdbc().queryForList(queryData.getSQL(), queryData.getData(), recType);
        return new PageResult<T>(paginator, entList);
    }

    public <T> PageResult<T> queryBySQL(Class<T> recType, String sqlQuery, Paginator paginator, Sechma useSechma, Map<String, Object> params) throws SQLException {
        SQLBuilder builder = this.getSQLBuilder();
        SQLBuilder.BuilderMapData queryData = builder.buildPaginator(sqlQuery, paginator, params);
        if (recType == Record.class) {
            LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{queryData});
            List<Record> entList = this.getJdbc().query(queryData.getSQL(), queryData.getData(), this.getRecordRowMapper(useSechma));
            return new PageResult<Record>(paginator, entList);
        }
        LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{queryData});
        List<T> entList = this.getJdbc().queryForList(queryData.getSQL(), queryData.getData(), recType);
        return new PageResult<T>(paginator, entList);
    }

    public Record loadData(Record ent) throws SQLException {
        this.checkID(ent);
        Sechma sechma = ent.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] idColumn = DataBase.as(sechma.getPrimaryKey());
        Object[] idValue = DataBase.as(ent.getID());
        SQLBuilder.BuilderData loadData = builder.buildSelect(sechma, idColumn, idValue);
        LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{loadData});
        Map<String, Object> dataContainer = this.getJdbc().queryForMap(loadData.getSQL(), loadData.getData());
        ent.setMap(dataContainer);
        return ent;
    }

    public int delete(Record ent) throws SQLException {
        this.checkID(ent);
        Sechma sechma = ent.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] idColumn = DataBase.as(sechma.getPrimaryKey());
        Object[] idValue = DataBase.as(ent.getID());
        SQLBuilder.BuilderData deleteData = builder.buildDelete(sechma, idColumn, idValue);
        LoggerHelper.logInfo((String)"deleteSQL:%s", (Object[])new Object[]{deleteData});
        return this.getJdbc().update(deleteData.getSQL(), deleteData.getData());
    }

    public int update(Record ent) throws SQLException {
        this.checkID(ent);
        Sechma sechma = ent.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] idColumn = DataBase.as(sechma.getPrimaryKey());
        Object[] idValue = DataBase.as(ent.getID());
        SQLBuilder.BuilderData countData = builder.buildCount(sechma, idColumn, idValue);
        JdbcOperations jdbc = this.getJdbc();
        if (jdbc.queryForInt(countData.getSQL(), countData.getData()) > 0) {
            Column[] updateColumn = ent.hasValueColumns(sechma.getUpdateColumns());
            Object[] updateData = ent.columnValues(updateColumn);
            SQLBuilder.BuilderData updateSqlData = builder.buildUpdate(sechma, idColumn, idValue, updateColumn, updateData);
            LoggerHelper.logInfo((String)"updateSQL:%s", (Object[])new Object[]{updateSqlData});
            return jdbc.update(updateSqlData.getSQL(), updateSqlData.getData());
        }
        throw new SQLException("record does not exist.");
    }

    public boolean saveOrUpdate(Record ent) throws SQLException {
        this.checkID(ent);
        if (this.existByID(ent)) {
            return this.saveAsNew(ent);
        }
        return this.update(ent) > 0;
    }

    public boolean saveAsNew(Record ent) throws SQLException {
        Sechma sechma = ent.getSechma();
        Column keyColumn = sechma.getPrimaryKey();
        if (keyColumn != null && ent.isNull(keyColumn.getName())) {
            Identify identify = this.getIdentify(sechma);
            if (identify != null) {
                Object newID = identify.newUniqueID(ent, sechma, this.getJdbc());
                ent.set(keyColumn, newID);
            }
            this.checkID(ent);
        }
        JdbcOperations jdbc = this.getJdbc();
        Column[] insertColumn = ent.hasValueColumns(sechma.getColumns());
        Object[] insertParam = ent.columnValues(insertColumn);
        SQLBuilder builder = this.getSQLBuilder();
        SQLBuilder.BuilderData insertData = builder.buildInsert(sechma, insertColumn, insertParam);
        LoggerHelper.logInfo((String)"insertSQL:%s", (Object[])new Object[]{insertData});
        return jdbc.update(insertData.getSQL(), insertData.getData()) > 0;
    }

    public boolean existByID(Record ent) throws SQLException {
        this.checkID(ent);
        Sechma sechma = ent.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] idColumn = DataBase.as(sechma.getPrimaryKey());
        Object[] idValue = DataBase.as(ent.getID());
        SQLBuilder.BuilderData countData = builder.buildCount(sechma, idColumn, idValue);
        LoggerHelper.logInfo((String)"countSQL:%s", (Object[])new Object[]{countData});
        return this.getJdbc().queryForInt(countData.getSQL(), countData.getData()) > 0;
    }

    public int countByExample(Record example) throws SQLException {
        Sechma sechma = example.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] allColumn = example.hasValueColumns(sechma.getColumns());
        Object[] dataArrays = example.columnValues(allColumn);
        SQLBuilder.BuilderData countData = builder.buildCount(sechma, allColumn, dataArrays);
        LoggerHelper.logInfo((String)"countSQL:%s", (Object[])new Object[]{countData});
        return this.getJdbc().queryForInt(countData.getSQL(), countData.getData());
    }

    public int deleteByExample(Record example) throws SQLException {
        Sechma sechma = example.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] allColumn = example.hasValueColumns(sechma.getColumns());
        Object[] dataArrays = example.columnValues(allColumn);
        SQLBuilder.BuilderData deleteData = builder.buildDelete(sechma, allColumn, dataArrays);
        LoggerHelper.logInfo((String)"deleteSQL:%s", (Object[])new Object[]{deleteData});
        return this.getJdbc().update(deleteData.getSQL(), deleteData.getData());
    }

    public int updateByExample(Record example, Map<String, Object> dataContainer) throws SQLException {
        if (dataContainer == null || dataContainer.isEmpty()) {
            return 0;
        }
        return this.updateByExample(example, new MapRecord(example.getSechma(), dataContainer));
    }

    public int updateByExample(Record example, Record dataContainer) throws SQLException {
        if (dataContainer == null) {
            return 0;
        }
        Sechma sechma = example.getSechma();
        SQLBuilder builder = this.getSQLBuilder();
        Column[] whereColumn = example.hasValueColumns(sechma.getColumns());
        Object[] whereArrays = example.columnValues(whereColumn);
        Column[] dataColumn = dataContainer.hasValueColumns(sechma.getUpdateColumns());
        Object[] dataArrays = dataContainer.columnValues(dataColumn);
        SQLBuilder.BuilderData updateData = builder.buildUpdate(sechma, whereColumn, whereArrays, dataColumn, dataArrays);
        LoggerHelper.logInfo((String)"updateSQL:%s", (Object[])new Object[]{updateData});
        return this.getJdbc().update(updateData.getSQL(), updateData.getData());
    }

    public PageResult<Record> listByExample(Record example) throws SQLException {
        return this.listByExample(Record.class, example, null, example.getSechma());
    }

    public PageResult<Record> listByExample(Record example, Paginator paginator) throws SQLException {
        return this.listByExample(Record.class, example, paginator, example.getSechma());
    }

    public <T> PageResult<T> listByExample(Class<T> recType, Record example) throws SQLException {
        return this.listByExample(recType, example, null, this.loadSechma(recType));
    }

    public <T> PageResult<T> listByExample(Class<T> recType, Record example, Paginator paginator) throws SQLException {
        return this.listByExample(recType, example, paginator, this.loadSechma(recType));
    }

    public <T> PageResult<T> listByExample(Class<T> recType, Record example, Paginator paginator, Sechma useSechma) throws SQLException {
        SQLBuilder builder = this.getSQLBuilder();
        Sechma sechma = example.getSechma();
        Column[] whereColumn = example.hasValueColumns(sechma.getColumns());
        Object[] whereArrays = example.columnValues(whereColumn);
        SQLBuilder.BuilderData selectData = builder.buildSelect(sechma, whereColumn, whereArrays);
        selectData = builder.buildPaginator(selectData.getSQL(), paginator, selectData.getData());
        if (recType == Record.class) {
            LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{selectData});
            List<Record> entList = this.getJdbc().query(selectData.getSQL(), selectData.getData(), this.getRecordRowMapper(useSechma));
            return new PageResult<Record>(paginator, entList);
        }
        LoggerHelper.logInfo((String)"selectSQL:%s", (Object[])new Object[]{selectData});
        List<T> entList = this.getJdbc().queryForList(selectData.getSQL(), recType, selectData.getData());
        return new PageResult<T>(paginator, entList);
    }

    private void checkID(Record ent) {
        Object idValue = ent.getID();
        if (idValue == null) {
            throw new NullPointerException("id field is empty.");
        }
    }

    private RowMapper<Record> getRecordRowMapper(Sechma sechma) {
        return new RecordRowMapper(sechma == null ? new Sechma("none") : sechma);
    }

    public JdbcOperations getJdbc() {
        return new JdbcTemplate(this.dataSource);
    }

    public DataBase(DataSource dataSource, SQLBuilderEnum dialectEnum) {
        this.dataSource = dataSource;
        this.sqlBuilder = dialectEnum.createBuilder();
    }

    private static <T> T[] as(T ... arr) {
        return arr;
    }

    protected SQLBuilder getSQLBuilder() {
        return this.sqlBuilder;
    }

    protected Identify getIdentify(Sechma sechma) {
        return arConfiguration.getIdentify(sechma);
    }

    public Sechma loadSechma(Class<?> sechmaType) {
        return arConfiguration.loadSechma(sechmaType);
    }

    private static class RecordRowMapper
    implements RowMapper<Record> {
        private ColumnMapRowMapper mapRowMapper = new ColumnMapRowMapper();
        private Sechma sechma = null;

        public RecordRowMapper(Sechma sechma) {
            this.sechma = (Sechma)Hasor.assertIsNotNull((Object)sechma);
        }

        @Override
        public Record mapRow(ResultSet rs, int rowNum) throws SQLException {
            Object data = this.mapRowMapper.mapRow(rs, rowNum);
            return new MapRecord(this.sechma, (Map<String, Object>)data);
        }
    }
}

