/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar;

import java.io.Serializable;
import java.lang.reflect.Field;
import net.hasor.db.orm.ar.InnerArUtils;
import org.more.builder.ReflectionToStringBuilder;
import org.more.builder.ToStringStyle;

public final class Column
implements Serializable {
    private static final long serialVersionUID = 7779635033083814425L;
    private String name = null;
    private String title = null;
    private int sqlType = 0;
    private Field beanField = null;
    private boolean primaryKey = false;
    private Integer maxSize = null;
    private boolean identify = false;
    private boolean empty = true;
    private Object defaultValue = null;
    private boolean insert = true;
    private boolean update = true;
    private boolean deleteWhere = true;
    private boolean updateWhere = true;
    private boolean ignoreUnset = true;

    public Column(String colName, int colSQLType) {
        this.name = colName;
        this.sqlType = colSQLType;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public Field getBeanField() {
        return this.beanField;
    }

    public Class<?> getJavaType() {
        return InnerArUtils.sqlTypeToJavaType(this.getSqlType());
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public int getMaxSize() {
        return this.maxSize == null ? 0 : this.maxSize;
    }

    public boolean isIdentify() {
        return this.identify;
    }

    public boolean allowInsert() {
        return this.insert;
    }

    public boolean allowUpdate() {
        return this.update;
    }

    public boolean allowDeleteWhere() {
        return this.deleteWhere;
    }

    public boolean allowUpdateWhere() {
        return this.updateWhere;
    }

    public boolean allowEmpty() {
        return this.empty;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isIgnoreUnset() {
        return this.ignoreUnset;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setBeanField(Field beanField) {
        this.beanField = beanField;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected void setAllowInsert(boolean insert) {
        this.insert = insert;
    }

    protected void setAllowUpdate(boolean update) {
        this.update = update;
    }

    protected void setAllowDeleteWhere(boolean deleteWhere) {
        this.deleteWhere = deleteWhere;
    }

    protected void setAllowUpdateWhere(boolean updateWhere) {
        this.updateWhere = updateWhere;
    }

    protected void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    protected void setIdentify(boolean identify) {
        this.identify = identify;
    }

    protected void setEmpty(boolean empty) {
        this.empty = empty;
    }

    protected void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    protected void setIgnoreUnset(boolean ignoreUnset) {
        this.ignoreUnset = ignoreUnset;
    }
}

