/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm.ar;

import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.db.orm.ar.Column;
import net.hasor.db.orm.ar.Identify;
import net.hasor.db.orm.ar.InnerArUtils;
import net.hasor.db.orm.ar.Sechma;
import net.hasor.db.orm.ar.anno.AllowPolicy;
import net.hasor.db.orm.ar.anno.Table;
import org.more.util.BeanUtils;
import org.more.util.StringUtils;

public final class ArConfiguration {
    private static ConcurrentHashMap<Class<?>, Sechma> sechmaMap = new ConcurrentHashMap();

    protected Identify getIdentify(Sechma sechma) {
        return null;
    }

    public Sechma loadSechma(Class<?> sechmaType) {
        Sechma sechma = sechmaMap.get(sechmaType);
        if (sechma == null) {
            sechma = ArConfiguration.parseSechma(sechmaType);
            sechmaMap.putIfAbsent(sechmaType, sechma);
        }
        return sechmaMap.get(sechmaType);
    }

    private static Sechma parseSechma(Class<?> sechmaType) {
        Table table = sechmaType.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        String tableName = StringUtils.isBlank((String)table.tableName()) ? sechmaType.getSimpleName() : table.tableName();
        Sechma sechma = new Sechma(tableName.toUpperCase());
        sechma.setIgnoreUnset(table.ignoreUnset());
        List propNames = BeanUtils.findALLFields(sechmaType);
        for (Field propField : propNames) {
            Class<?> propType = propField.getType();
            Column col = new Column(propField.getName(), InnerArUtils.javaTypeToSqlType(propType));
            col.setBeanField(propField);
            col.setIgnoreUnset(sechma.isIgnoreUnset());
            net.hasor.db.orm.ar.anno.Column column = propField.getAnnotation(net.hasor.db.orm.ar.anno.Column.class);
            if (column != null) {
                col.setMaxSize(column.size());
                col.setName(column.column());
                AllowPolicy policy = column.policy();
                col.setAllowInsert(policy.insert());
                col.setAllowUpdate(policy.update());
                col.setAllowDeleteWhere(policy.deleteWhere());
                col.setAllowUpdateWhere(policy.updateWhere());
                col.setIgnoreUnset(policy.ignoreUnset());
                col.setEmpty(column.isNull());
            }
            sechma.addColumn(col);
        }
        return sechma;
    }
}

