/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm;

import java.util.ArrayList;
import java.util.List;

public class Paginator {
    private int totalCount = 0;
    private int pageSize = 15;
    private int currentPage = 0;
    private boolean enable = true;
    private final List<Order> orderBy = new ArrayList<Order>(0);

    public List<Order> getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(List<Order> orderBy) {
        this.orderBy.clear();
        this.orderBy.addAll(orderBy);
    }

    public void addOrderBy(String sortField, Order.OrderBy orderBy) {
        Order order = new Order();
        order.sortField = sortField;
        order.orderBy = orderBy;
        this.orderBy.add(order);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        if (pageSize < 1) {
            pageSize = 1;
        }
        this.pageSize = pageSize;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        if (totalCount < 0) {
            totalCount = 0;
        }
        this.totalCount = totalCount;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isFirstPage() {
        return this.getCurrentPage() == 1;
    }

    public boolean hasPreviousPage() {
        return !this.isFirstPage();
    }

    public int getPreviousPage() {
        int back = this.getCurrentPage() - 1;
        return back < 0 ? 0 : back;
    }

    public int getNextPage() {
        int back = this.getCurrentPage() + 1;
        return back > this.getTotalPage() ? this.getTotalPage() : back;
    }

    public boolean hasNextPage() {
        return !this.isLastPage();
    }

    public boolean isLastPage() {
        return this.getTotalPage() <= this.getCurrentPage();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 0) {
            currentPage = 0;
        }
        this.currentPage = currentPage;
    }

    public int getTotalPage() {
        int pgSize = this.getPageSize();
        int result = 1;
        if (pgSize > 0) {
            int totalCount = this.getTotalCount();
            result = this.getTotalCount() / pgSize;
            if (totalCount == 0 || totalCount % pgSize != 0) {
                ++result;
            }
        }
        return result;
    }

    public int getFirstItem() {
        int cPage = this.getCurrentPage();
        int pgSize = this.getPageSize();
        return pgSize * cPage;
    }

    public int getLastItem() {
        int totalCount;
        int cPage = this.getCurrentPage();
        int pgSize = this.getPageSize();
        int assumeLast = pgSize + pgSize * cPage;
        return assumeLast > (totalCount = this.getTotalCount()) ? totalCount : assumeLast;
    }

    public static final class Order {
        private String sortField = "";
        private OrderBy orderBy = OrderBy.ASC;

        public String getSortField() {
            return this.sortField;
        }

        public void setSortField(String sortField) {
            this.sortField = sortField;
        }

        public OrderBy getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(OrderBy orderBy) {
            this.orderBy = orderBy;
        }

        public static enum OrderBy {
            ASC,
            DESC;

        }
    }
}

