/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.orm;

import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.orm.PageResult;
import net.hasor.db.orm.Paginator;
import net.hasor.db.orm.ar.DataBase;
import net.hasor.db.orm.ar.Record;
import net.hasor.db.orm.ar.Sechma;
import net.hasor.db.orm.ar.dialect.SQLBuilderEnum;
import net.hasor.db.orm.ar.record.ObjectRecord;
import org.more.util.ClassUtils;

public class AbstractDao<ENT> {
    private SQLBuilderEnum dialect = SQLBuilderEnum.MySql;
    private JdbcTemplate jdbcTemplate = new JdbcTemplate();

    public AbstractDao(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public AbstractDao(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public AbstractDao() {
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate.setDataSource(dataSource);
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setDialect(SQLBuilderEnum dialect) {
        this.dialect = dialect;
    }

    public SQLBuilderEnum getDialect() {
        return this.dialect;
    }

    public DataBase getDataBase() {
        return new DataBase(this.getDataSource(), this.dialect);
    }

    protected Class<ENT> getRecordType() {
        return ClassUtils.getSuperClassGenricType(this.getClass(), (int)0);
    }

    protected Record newRecord(ENT record) {
        Sechma sechma = this.getDataBase().loadSechma(this.getRecordType());
        return new ObjectRecord<ENT>(sechma, record);
    }

    protected boolean saveAsNew(ENT record) throws SQLException {
        return this.getDataBase().saveAsNew(this.newRecord(record));
    }

    protected boolean saveOrUpdate(ENT record) throws SQLException {
        return this.getDataBase().saveOrUpdate(this.newRecord(record));
    }

    protected int delete(ENT record) throws SQLException {
        return this.getDataBase().delete(this.newRecord(record));
    }

    protected int update(ENT record) throws SQLException {
        return this.getDataBase().update(this.newRecord(record));
    }

    protected int deleteByExample(ENT example) throws SQLException {
        return this.getDataBase().deleteByExample(this.newRecord(example));
    }

    protected int updateByExample(ENT example, ENT record) throws SQLException {
        return this.getDataBase().updateByExample(this.newRecord(example), this.newRecord(record));
    }

    protected PageResult<ENT> listByExample(ENT example) throws SQLException {
        return this.getDataBase().listByExample(this.getRecordType(), this.newRecord(example));
    }

    protected PageResult<ENT> listByExample(ENT example, Paginator pageInfo) throws SQLException {
        return this.getDataBase().listByExample(this.getRecordType(), this.newRecord(example), pageInfo);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery, Object ... params) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery, params);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery, Map<String, Object> params) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery, params);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery, Paginator paginator) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery, paginator);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery, Paginator paginator, Object ... params) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery, paginator, params);
    }

    protected PageResult<ENT> queryBySQL(String sqlQuery, Paginator paginator, Map<String, Object> params) throws SQLException {
        return this.getDataBase().queryBySQL(this.getRecordType(), sqlQuery, paginator, params);
    }
}

