/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.interceptor;

import java.lang.reflect.Method;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.AppContextAware;
import net.hasor.core.Hasor;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.binder.aop.matcher.AopMatchers;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.interceptor.FixedValueStrategy;
import net.hasor.db.transaction.interceptor.StrategyDefinition;
import net.hasor.db.transaction.interceptor.TranInterceptor;
import net.hasor.db.transaction.interceptor.TranOperations;
import net.hasor.db.transaction.interceptor.TranStrategy;
import org.more.util.ContextClassLoaderLocal;

public class TransactionBinder {
    private static ContextClassLoaderLocal<Boolean> initInterceptor = new ContextClassLoaderLocal((Object)false);
    private ApiBinder apiBinder = null;

    public TransactionBinder(ApiBinder apiBinder) {
        this.apiBinder = apiBinder;
        if (!((Boolean)initInterceptor.get()).booleanValue()) {
            TranInterceptor tranInterceptor = (TranInterceptor)this.apiBinder.autoAware((AppContextAware)new TranInterceptor());
            this.apiBinder.bindInterceptor(AopMatchers.anyClass(), AopMatchers.anyMethod(), (MethodInterceptor)tranInterceptor);
            initInterceptor.set((Object)true);
        }
    }

    public TranInterceptorBindBuilder bind(DataSource dataSource) {
        return new TranInterceptorBindBuilder(dataSource);
    }

    public static class TranIsolationBindBuilder {
        private StrategyDefinition strategyDefine = null;

        public TranIsolationBindBuilder(StrategyDefinition strategyDefine) {
            this.strategyDefine = strategyDefine;
        }

        public void withIsolation(Isolation isolation) {
            Hasor.assertIsNotNull((Object)((Object)isolation), (String)"param isolation is null.");
            this.withIsolation(new FixedValueStrategy<Isolation>(isolation));
        }

        public void withIsolation(TranStrategy<Isolation> isolation) {
            Hasor.assertIsNotNull(isolation, (String)"param isolation is null.");
            this.strategyDefine.setIsolation(isolation);
        }
    }

    public class TranPropagationBindBuilder {
        private StrategyDefinition strategyDefine = null;

        public TranPropagationBindBuilder(StrategyDefinition strategyDefine) {
            this.strategyDefine = strategyDefine;
        }

        public TranIsolationBindBuilder withPropagation(Propagation propagation) {
            Hasor.assertIsNotNull((Object)((Object)propagation), (String)"param propagation is null.");
            return this.withPropagation(new FixedValueStrategy<Propagation>(propagation));
        }

        public TranIsolationBindBuilder withPropagation(TranStrategy<Propagation> propagation) {
            Hasor.assertIsNotNull(propagation, (String)"param propagation is null.");
            this.strategyDefine.setPropagation(propagation);
            TransactionBinder.this.apiBinder.bindType(StrategyDefinition.class).uniqueName().toInstance((Object)this.strategyDefine);
            return new TranIsolationBindBuilder(this.strategyDefine);
        }
    }

    public class TranInterceptorBindBuilder {
        private DataSource dataSource = null;
        private TranOperations around = null;

        public TranInterceptorBindBuilder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public TranInterceptorBindBuilder aroundOperation(TranOperations around) {
            this.around = around;
            return this;
        }

        public TranPropagationBindBuilder matcher(String matcherExpression) {
            return this.matcher((ApiBinder.Matcher<Method>)AopMatchers.expressionMethod((String)matcherExpression));
        }

        public TranPropagationBindBuilder matcher(ApiBinder.Matcher<Method> matcher) {
            StrategyDefinition strategyDefine = new StrategyDefinition(this.dataSource, matcher);
            strategyDefine.setTranOperations(this.around);
            return new TranPropagationBindBuilder(strategyDefine);
        }
    }
}

