/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.provider;

import java.util.UUID;
import javax.sql.DataSource;
import net.hasor.core.ApiBinder;
import net.hasor.core.Hasor;
import net.hasor.core.Module;
import net.hasor.core.Provider;
import net.hasor.db.jdbc.core.JdbcTemplate;
import net.hasor.db.jdbc.core.JdbcTemplateProvider;
import net.hasor.db.transaction.interceptor.simple.SimpleTranInterceptorModule;

public class SimpleDBModule
implements Module {
    private String dataSourceID = UUID.randomUUID().toString();
    private DataSource dataSource = null;

    public SimpleDBModule(DataSource dataSource) {
        Hasor.assertIsNotNull((Object)dataSource, (String)"dataSource is null.");
        this.dataSource = dataSource;
    }

    public SimpleDBModule(String dataSourceID, DataSource dataSource) {
        Hasor.assertIsNotNull((Object)dataSourceID, (String)"dataSourceID is null.");
        Hasor.assertIsNotNull((Object)dataSource, (String)"dataSource is null.");
        this.dataSourceID = dataSourceID;
        this.dataSource = dataSource;
    }

    public void loadModule(ApiBinder apiBinder) throws Throwable {
        apiBinder.bindType(DataSource.class).idWith(this.dataSourceID).toInstance((Object)this.dataSource);
        apiBinder.bindType(JdbcTemplate.class).toProvider((Provider)new JdbcTemplateProvider(this.dataSource));
        apiBinder.installModule((Module)new SimpleTranInterceptorModule(this.dataSource));
    }
}

