/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.support;

import java.sql.SQLException;
import javax.sql.DataSource;
import net.hasor.db.datasource.SavepointManager;
import net.hasor.db.datasource.local.ConnectionHolder;
import net.hasor.db.transaction.Isolation;

public class TransactionObject {
    private ConnectionHolder holder = null;
    private DataSource dataSource = null;
    private Isolation oriIsolationLevel;
    private boolean recoverMark = false;

    public TransactionObject(ConnectionHolder holder, Isolation oriIsolationLevel, DataSource dataSource) throws SQLException {
        this.holder = holder;
        this.dataSource = dataSource;
        this.oriIsolationLevel = oriIsolationLevel;
    }

    public Isolation getOriIsolationLevel() {
        return this.oriIsolationLevel;
    }

    public ConnectionHolder getHolder() {
        return this.holder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public SavepointManager getSavepointManager() {
        return this.getHolder();
    }

    public void rollback() throws SQLException {
        if (this.holder.hasTransaction()) {
            this.holder.getConnection().rollback();
        }
    }

    public void commit() throws SQLException {
        if (this.holder.hasTransaction()) {
            this.holder.getConnection().commit();
        }
    }

    public boolean hasTransaction() throws SQLException {
        return this.holder.hasTransaction();
    }

    public void beginTransaction() throws SQLException {
        if (!this.holder.hasTransaction()) {
            this.recoverMark = true;
        }
        this.holder.setTransaction();
    }

    public void stopTransaction() throws SQLException {
        if (!this.recoverMark) {
            return;
        }
        this.recoverMark = false;
        this.holder.cancelTransaction();
    }
}

