/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.interceptor.simple;

import java.lang.reflect.Method;
import net.hasor.core.MethodInvocation;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.interceptor.TranOperations;
import net.hasor.db.transaction.interceptor.simple.RollBackSQLException;
import net.hasor.db.transaction.interceptor.simple.Transactional;

class TransactionOperation
implements TranOperations {
    TransactionOperation() {
    }

    @Override
    public Object execute(TransactionStatus tranStatus, MethodInvocation invocation) throws Throwable {
        Object returnObj;
        block6: {
            Method targetMethod = invocation.getMethod();
            Transactional tranAnno = targetMethod.getAnnotation(Transactional.class);
            if (tranAnno == null) {
                return invocation.proceed();
            }
            if (tranAnno.readOnly()) {
                tranStatus.setReadOnly();
            }
            returnObj = null;
            try {
                returnObj = invocation.proceed();
            }
            catch (RollBackSQLException e) {
                tranStatus.setRollbackOnly();
                return returnObj;
            }
            catch (Throwable e) {
                if (this.testRollBackFor(tranAnno, e)) {
                    tranStatus.setRollbackOnly();
                }
                if (this.testNoRollBackFor(tranAnno, e)) break block6;
                throw e;
            }
        }
        return returnObj;
    }

    private boolean testNoRollBackFor(Transactional tranAnno, Throwable e) {
        Class<? extends Throwable>[] noRollBackType;
        for (Class<? extends Throwable> cls : noRollBackType = tranAnno.noRollbackFor()) {
            if (!cls.isInstance(e)) continue;
            return true;
        }
        String[] noRollBackName = tranAnno.noRollbackForClassName();
        String errorType = e.getClass().getName();
        for (String name : noRollBackName) {
            if (!errorType.equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean testRollBackFor(Transactional tranAnno, Throwable e) {
        Class<? extends Throwable>[] rollBackType;
        for (Class<? extends Throwable> cls : rollBackType = tranAnno.rollbackFor()) {
            if (!cls.isInstance(e)) continue;
            return true;
        }
        String[] rollBackName = tranAnno.rollbackForClassName();
        String errorType = e.getClass().getName();
        for (String name : rollBackName) {
            if (!errorType.equals(name)) continue;
            return true;
        }
        return false;
    }
}

