/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.List;
import javax.sql.DataSource;
import net.hasor.core.AppContext;
import net.hasor.core.AppContextAware;
import net.hasor.core.MethodInterceptor;
import net.hasor.core.MethodInvocation;
import net.hasor.db.transaction.Isolation;
import net.hasor.db.transaction.Manager;
import net.hasor.db.transaction.Propagation;
import net.hasor.db.transaction.TransactionManager;
import net.hasor.db.transaction.TransactionStatus;
import net.hasor.db.transaction.interceptor.StrategyDefinition;
import net.hasor.db.transaction.interceptor.TranOperations;

class TranInterceptor
implements MethodInterceptor,
AppContextAware {
    private StrategyDefinition[] definitionArray = null;

    TranInterceptor() {
    }

    public void setAppContext(AppContext appContext) {
        List defineList = appContext.findBindingBean(StrategyDefinition.class);
        if (defineList != null && !defineList.isEmpty()) {
            this.definitionArray = defineList.toArray(new StrategyDefinition[defineList.size()]);
        }
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.definitionArray == null || this.definitionArray.length == 0) {
            return invocation.proceed();
        }
        Method targetMethod = invocation.getMethod();
        StrategyDefinition atDefine = null;
        for (StrategyDefinition define : this.definitionArray) {
            if (!define.matches(targetMethod)) continue;
            atDefine = define;
            break;
        }
        if (atDefine == null) {
            return invocation.proceed();
        }
        DataSource dataSource = atDefine.getDataSource();
        Propagation propagation = atDefine.getPropagationStrategy().getStrategy(targetMethod);
        Isolation isolation = atDefine.getIsolationStrategy().getStrategy(targetMethod);
        TranOperations around = atDefine.getAround();
        TransactionManager manager = Manager.getTransactionManager(dataSource);
        TransactionStatus tranStatus = null;
        try {
            tranStatus = manager.getTransaction(propagation, isolation);
            Object object = around.execute(tranStatus, invocation);
            return object;
        }
        catch (Throwable e) {
            if (tranStatus != null) {
                tranStatus.setRollbackOnly();
            }
            throw e;
        }
        finally {
            if (tranStatus != null && !tranStatus.isCompleted()) {
                manager.commit(tranStatus);
            }
        }
    }
}

