/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.jdbc.core.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import net.hasor.db.jdbc.core.LinkedCaseInsensitiveMap;
import net.hasor.db.jdbc.core.mapper.AbstractRowMapper;

public class ColumnMapRowMapper
extends AbstractRowMapper<Map<String, Object>> {
    @Override
    public final Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            String key = this.getColumnKey(ColumnMapRowMapper.lookupColumnName(rsmd, i));
            Object obj = this.getColumnValue(rs, i);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    private static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return AbstractRowMapper.getResultSetValue(rs, index);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap<Object>(columnCount);
    }
}

