/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.datasource.local;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.hasor.db.datasource.DataSourceHelper;
import net.hasor.db.datasource.local.ConnectionHolder;
import net.hasor.db.datasource.local.ConnectionSequence;

public class LocalDataSourceHelper
implements DataSourceHelper {
    private static final ThreadLocal<Map<DataSource, ConnectionSequence>> ResourcesLocal = new ThreadLocal<Map<DataSource, ConnectionSequence>>(){

        @Override
        protected Map<DataSource, ConnectionSequence> initialValue() {
            return new HashMap<DataSource, ConnectionSequence>();
        }
    };

    @Override
    public Connection getConnection(DataSource dataSource) throws SQLException {
        ConnectionSequence conSeq = this.getConnectionSequence(dataSource);
        ConnectionHolder connHolder = conSeq.currentHolder();
        connHolder.requested();
        return connHolder.getConnection();
    }

    @Override
    public void releaseConnection(Connection con, DataSource dataSource) throws SQLException {
        ConnectionSequence conSeq = this.getConnectionSequence(dataSource);
        ConnectionHolder holder = conSeq.currentHolder();
        if (holder != null) {
            holder.released();
        }
    }

    @Override
    public Connection currentConnection(DataSource dataSource) throws SQLException {
        ConnectionSequence conSeq = this.getConnectionSequence(dataSource);
        ConnectionHolder holder = conSeq.currentHolder();
        return holder.getConnection();
    }

    public ConnectionSequence getConnectionSequence(DataSource dataSource) {
        ConnectionSequence conSeq = ResourcesLocal.get().get(dataSource);
        if (conSeq == null) {
            conSeq = this.createConnectionSequence();
            ResourcesLocal.get().put(dataSource, conSeq);
        }
        if (conSeq.currentHolder() == null) {
            conSeq.push(this.createConnectionHolder(dataSource));
        }
        return conSeq;
    }

    protected ConnectionSequence createConnectionSequence() {
        return new ConnectionSequence();
    }

    protected ConnectionHolder createConnectionHolder(DataSource dataSource) {
        return new ConnectionHolder(dataSource);
    }
}

