/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.db.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.hasor.db.datasource.DataSourceHelper;
import net.hasor.db.datasource.local.LocalDataSourceHelper;
import org.more.util.ContextClassLoaderLocal;

public class DataSourceUtils {
    private static ServiceLocal utilServiceLocal = new ServiceLocal();

    public static Connection getConnection(DataSource dataSource) throws SQLException {
        DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
        Connection conn = utilService.getConnection(dataSource);
        if (conn == null) {
            throw new SQLException("getConnection. return null.");
        }
        return conn;
    }

    public static void releaseConnection(Connection con, DataSource dataSource) throws SQLException {
        DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
        utilService.releaseConnection(con, dataSource);
    }

    public static Connection currentConnection(DataSource dataSource) throws SQLException {
        DataSourceHelper utilService = (DataSourceHelper)utilServiceLocal.get();
        return utilService.currentConnection(dataSource);
    }

    public static DataSourceHelper getDataSourceHelper() {
        return (DataSourceHelper)utilServiceLocal.get();
    }

    protected static void changeDataSourceUtilService(DataSourceHelper utilService) {
        utilServiceLocal.set(utilService);
    }

    private static class ServiceLocal
    extends ContextClassLoaderLocal<DataSourceHelper> {
        private ServiceLocal() {
        }

        protected DataSourceHelper initialValue() {
            return new LocalDataSourceHelper();
        }
    }
}

