/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mojo.dataql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class MojoUtils {
    MojoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] checksum(File file) throws IOException {
        try {
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[2048];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            try {
                int n;
                do {
                    if ((n = ((InputStream)in).read(buffer)) <= 0) continue;
                    complete.update(buffer, 0, n);
                } while (n != -1);
            }
            finally {
                ((InputStream)in).close();
            }
            return complete.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("Could not create checksum " + file, ex);
        }
    }

    public static String findSourceSubdir(File sourceDirectory, File queryFile) {
        String srcPath = sourceDirectory.getPath() + File.separator;
        String path = queryFile.getPath();
        if (!path.startsWith(srcPath)) {
            throw new IllegalArgumentException("expected " + path + " to be prefixed with " + sourceDirectory);
        }
        File unprefixedGrammarFileName = new File(path.substring(srcPath.length()));
        if (unprefixedGrammarFileName.getParent() == null) {
            return "";
        }
        return unprefixedGrammarFileName.getParent() + File.separator;
    }
}

