/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.mojo.dataql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hasor.dataql.compiler.ast.inst.HintInst;
import net.hasor.dataql.compiler.ast.inst.RootBlockSet;
import net.hasor.dataql.compiler.ast.value.PrimitiveVariable;
import net.hasor.dataql.runtime.QueryHelper;
import net.hasor.mojo.dataql.MojoUtils;
import net.hasor.utils.ResourcesUtils;
import net.hasor.utils.StringUtils;
import net.hasor.utils.io.AutoCloseInputStream;
import net.hasor.utils.io.FileUtils;
import net.hasor.utils.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="dataql", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class QueryMojo
extends AbstractMojo {
    @Parameter(property="project.build.sourceEncoding")
    protected String inputEncoding;
    @Parameter(property="project.build.sourceEncoding")
    protected String outputEncoding;
    @Parameter
    protected Set<String> includes = new HashSet<String>();
    @Parameter
    protected Set<String> excludes = new HashSet<String>();
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/main/java")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/dataql")
    private File outputSourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/generated-resources/dataql")
    private File outputResourceDirectory;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="false")
    private boolean ignoreError;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.outputEncoding = this.validateEncoding(this.outputEncoding);
        if (log.isDebugEnabled()) {
            for (String e : this.excludes) {
                log.debug((CharSequence)("DataQL: Exclude: " + e));
            }
            for (String e : this.includes) {
                log.debug((CharSequence)("DataQL: Include: " + e));
            }
            log.debug((CharSequence)("DataQL: Output: " + this.outputSourceDirectory));
        }
        if (!this.sourceDirectory.isDirectory()) {
            log.info((CharSequence)("No DataQL files to compile in " + this.sourceDirectory.getAbsolutePath()));
            return;
        }
        try {
            log.info((CharSequence)("delete generate Query Jave Class in Directory " + this.sourceDirectory.getAbsolutePath()));
            FileUtils.deleteDirectory((File)this.outputSourceDirectory);
            if (!this.outputSourceDirectory.exists()) {
                this.outputSourceDirectory.mkdirs();
            }
            log.info((CharSequence)("delete generate Query Resource in Directory " + this.outputResourceDirectory.getAbsolutePath()));
            FileUtils.deleteDirectory((File)this.outputResourceDirectory);
            if (!this.outputResourceDirectory.exists()) {
                this.outputResourceDirectory.mkdirs();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (!this.project.getCompileSourceRoots().contains(this.outputSourceDirectory.getAbsolutePath())) {
            log.info((CharSequence)("DataQL directory " + this.outputSourceDirectory.getAbsolutePath() + " add to CompileSource Directory."));
            this.project.addCompileSourceRoot(this.outputSourceDirectory.getAbsolutePath());
        }
        if (!this.project.getResources().contains(this.outputResourceDirectory.getAbsolutePath())) {
            log.info((CharSequence)("DataQL directory " + this.outputResourceDirectory.getAbsolutePath() + " add to Resource Directory."));
            Resource resource = new Resource();
            resource.setDirectory(this.outputResourceDirectory.getAbsolutePath());
            this.project.addResource(resource);
        }
        log.info((CharSequence)("DataQL : Processing source directory " + this.outputSourceDirectory.getAbsolutePath()));
        try {
            List stringList = IOUtils.readLines((InputStream)ResourcesUtils.getResourceAsStream((String)"/META-INF/dataql-codegen-template.tpl"), (String)"UTF-8");
            String javaTemp = StringUtils.join((Object[])stringList.toArray(new String[0]), (String)"\n");
            SimpleSourceInclusionScanner scan = new SimpleSourceInclusionScanner(this.getIncludesPatterns(), this.excludes);
            scan.addSourceMapping((SourceMapping)new SuffixMapping("ql", Collections.emptySet()));
            Set qlFiles = scan.getIncludedSources(this.sourceDirectory, null);
            for (File qlFile : qlFiles) {
                this.buildContext.refresh(qlFile);
                this.buildContext.removeMessages(qlFile);
                log.info((CharSequence)("Query file '" + qlFile.getPath() + "' detected."));
                String relPathBase = MojoUtils.findSourceSubdir(this.sourceDirectory, qlFile);
                String relPath = relPathBase + qlFile.getName();
                this.getLog().debug((CharSequence)("  ... relative path is: " + relPath));
                boolean javaxInject = false;
                String javaxInjectName = "";
                try {
                    RootBlockSet queryModel = (RootBlockSet)QueryHelper.queryParser((InputStream)new AutoCloseInputStream((InputStream)new FileInputStream(qlFile)));
                    List optionSet = queryModel.getOptionSet();
                    for (HintInst inst : optionSet) {
                        if ("javax_inject".equalsIgnoreCase(inst.getHint()) && inst.getValue().getValueType() == PrimitiveVariable.ValueType.Boolean) {
                            javaxInject = (Boolean)inst.getValue().getValue();
                        }
                        if (!"javax_inject_name".equalsIgnoreCase(inst.getHint()) || inst.getValue().getValueType() == PrimitiveVariable.ValueType.Null) continue;
                        javaxInjectName = inst.getValue().getValue().toString();
                    }
                }
                catch (Exception e) {
                    if (!this.ignoreError) {
                        throw e;
                    }
                    this.getLog().error((Throwable)e);
                }
                String injectReplaceString = "";
                if (javaxInject) {
                    if (StringUtils.isNotBlank((String)javaxInjectName)) {
                        injectReplaceString = "\"" + javaxInjectName.trim() + "\"";
                    }
                    injectReplaceString = "@javax.inject.Named(" + javaxInjectName + ")";
                }
                FileInputStream sourceQueryFile = FileUtils.openInputStream((File)qlFile);
                Object object = null;
                try {
                    File outFile = new File(this.outputResourceDirectory, relPath);
                    try (FileOutputStream targetQueryFile = FileUtils.openOutputStream((File)outFile);){
                        IOUtils.copy((InputStream)sourceQueryFile, (OutputStream)targetQueryFile);
                        targetQueryFile.flush();
                    }
                }
                catch (Throwable outFile) {
                    object = outFile;
                    throw outFile;
                }
                finally {
                    if (sourceQueryFile != null) {
                        if (object != null) {
                            try {
                                ((InputStream)sourceQueryFile).close();
                            }
                            catch (Throwable outFile) {
                                ((Throwable)object).addSuppressed(outFile);
                            }
                        } else {
                            ((InputStream)sourceQueryFile).close();
                        }
                    }
                }
                String className = qlFile.getName().split("\\.")[0] + "Query";
                String targetPackageName = "";
                if (StringUtils.isNotBlank((String)relPathBase)) {
                    targetPackageName = "package " + relPathBase.replace(File.separator, ".");
                    targetPackageName = targetPackageName.substring(0, targetPackageName.length() - 1) + ";";
                }
                String targetJavaName = relPath.replace(File.separator, ".");
                String tempClass = new String((char[])javaTemp.toCharArray().clone());
                tempClass = tempClass.replace("%target_pacakge%", targetPackageName);
                tempClass = tempClass.replace("%source_resource%", "/" + relPath.replace(File.separator, "/"));
                tempClass = tempClass.replace("%target_name%", className);
                tempClass = tempClass.replace("%inject_name%", injectReplaceString);
                File outFile = new File(new File(this.outputSourceDirectory, relPath).getParentFile(), className + ".java");
                FileOutputStream targetQueryFile = FileUtils.openOutputStream((File)outFile);
                Throwable throwable = null;
                try {
                    ((OutputStream)targetQueryFile).write(tempClass.getBytes());
                    targetQueryFile.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (targetQueryFile == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)targetQueryFile).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)targetQueryFile).close();
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new MojoExecutionException("Fatal error occured while evaluating the names of the query files to analyze", e);
        }
    }

    private Set<String> getIncludesPatterns() {
        if (this.includes == null || this.includes.isEmpty()) {
            return Collections.singleton("**/*.ql");
        }
        return this.includes;
    }

    private String validateEncoding(String encoding) {
        return encoding == null ? Charset.defaultCharset().name() : Charset.forName(encoding.trim()).name();
    }
}

