/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.ResourceLoader;

public class PathResourceLoader
extends AbstractResourceLoader {
    private final List<File> dirPathList = new ArrayList<File>();

    public PathResourceLoader() {
        this(null, null);
    }

    public PathResourceLoader(File dirFile) {
        this(null, dirFile);
    }

    public PathResourceLoader(ClassLoader parent) {
        this(parent, null);
    }

    public PathResourceLoader(ClassLoader parent, File dirFile) {
        super(parent);
        if (dirFile != null) {
            this.addPath(dirFile);
        }
    }

    public void addPath(File dirFile) {
        if (dirFile.exists() && dirFile.isDirectory()) {
            this.dirPathList.add(dirFile);
        }
    }

    private List<File> formatResourcePath(String resource) {
        return this.dirPathList.stream().filter(File::exists).map(file -> new File((File)file, resource)).collect(Collectors.toList());
    }

    @Override
    public URL getResource(String resource) throws IOException {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return file.toURI().toURL();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) throws IOException {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            result.add(file.toURI().toURL());
        }
        return result;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            result.add(new FileInputStream(file));
        }
        return result;
    }

    @Override
    public boolean exist(String resource) {
        List<File> resourcePaths = this.formatResourcePath(resource);
        for (File file : resourcePaths) {
            if (!file.exists() || !file.isFile()) continue;
            return true;
        }
        return false;
    }

    protected boolean testFound(File entry, Predicate<File>[] testPredicates) {
        if (testPredicates == null || testPredicates.length == 0) {
            return true;
        }
        for (Predicate<File> predicate : testPredicates) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private <T> void scanDirFile(File baseDir, List<T> result, File scanDir, ResourceLoader.Scanner<T> scanner, Predicate<File>[] scanPaths, boolean matchOnce) throws IOException {
        File[] listFiles = scanDir.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File fileItem : listFiles) {
            String resourceName;
            if (matchOnce && !result.isEmpty()) {
                return;
            }
            if (fileItem.isHidden() || !fileItem.exists() || !this.testFound(new File(resourceName = fileItem.getAbsolutePath().substring(baseDir.getAbsolutePath().length() + 1)), scanPaths)) continue;
            if (fileItem.isDirectory()) {
                this.scanDirFile(baseDir, result, fileItem, scanner, scanPaths, matchOnce);
                continue;
            }
            ResourceLoader.InputStreamGet inputStream = () -> {
                if (fileItem.canRead()) {
                    return new FileInputStream(fileItem);
                }
                throw new IOException("file cannot be read :" + fileItem);
            };
            T res = scanner.found(new ResourceLoader.ScanEvent(resourceName, fileItem.length(), fileItem.toURI().toURL(), inputStream));
            if (res == null) continue;
            result.add(res);
        }
    }

    @Override
    public <T> List<T> scanResources(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<File>[] tests = this.buildPredicate(matchType, scanPaths, File::getPath);
        for (File baseDir : this.dirPathList) {
            if (!baseDir.exists()) continue;
            this.scanDirFile(baseDir, result, baseDir, scanner, tests, false);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<File>[] tests = this.buildPredicate(matchType, scanPaths, File::getPath);
        for (File baseDir : this.dirPathList) {
            if (!baseDir.exists()) continue;
            this.scanDirFile(baseDir, result, baseDir, scanner, tests, true);
        }
        return result.isEmpty() ? null : (T)result.get(0);
    }
}

