/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader.providers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import net.hasor.cobble.loader.AbstractResourceLoader;
import net.hasor.cobble.loader.ResourceLoader;
import net.hasor.cobble.loader.jar.JarFile;

public class ClassPathResourceLoader
extends AbstractResourceLoader {
    public static ResourceLoader INSTANCE = new ClassPathResourceLoader();
    private final ClassLoader classLoader;
    private final List<URL> classpath;

    public ClassPathResourceLoader() {
        super(Thread.currentThread().getContextClassLoader());
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.classpath = ClassPathResourceLoader.getClassPath(this.classLoader);
    }

    public ClassPathResourceLoader(ClassLoader parent) {
        super(parent);
        this.classLoader = Objects.requireNonNull(parent);
        this.classpath = ClassPathResourceLoader.getClassPath(this.classLoader);
    }

    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    private static List<URL> getClassPath(ClassLoader classLoader) {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        while (classLoader != null) {
            classLoaders.add(classLoader);
            classLoader = classLoader.getParent();
        }
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader loader : classLoaders) {
            URL[] urLs;
            if (!(loader instanceof URLClassLoader) || (urLs = ((URLClassLoader)loader).getURLs()) == null) continue;
            for (URL url : urLs) {
                if (resources.contains(url)) continue;
                resources.add(url);
            }
        }
        return resources;
    }

    private String formatResourcePath(String resourcePath) {
        if ((resourcePath = resourcePath.replaceAll("/{2}", "/")).charAt(0) == '/') {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    @Override
    public URL getResource(String resource) throws IOException {
        return this.classLoader.getResource(this.formatResourcePath(resource));
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        return this.classLoader.getResourceAsStream(this.formatResourcePath(resource));
    }

    @Override
    public List<URL> getResources(String resource) throws IOException {
        resource = this.formatResourcePath(resource);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(resource);
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    @Override
    public List<InputStream> getResourcesAsStream(String resource) throws IOException {
        resource = this.formatResourcePath(resource);
        ArrayList<InputStream> ins = new ArrayList<InputStream>();
        Enumeration<URL> urlEnumeration = this.classLoader.getResources(resource);
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            InputStream in = url != null ? url.openStream() : null;
            if (in == null) continue;
            ins.add(in);
        }
        return ins;
    }

    @Override
    public boolean exist(String resource) {
        return this.classLoader.getResource(this.formatResourcePath(resource)) != null;
    }

    @Override
    public <T> List<T> scanResources(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<JarEntry>[] testJar = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
        Predicate<File>[] testDir = this.buildPredicate(matchType, scanPaths, File::getPath);
        for (URL url : this.classpath) {
            java.util.jar.JarFile jarFile;
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File contextDir = new File(URLDecoder.decode(url.getFile()));
                if (contextDir.isDirectory()) {
                    ClassPathResourceLoader.dirScan(result, contextDir, contextDir, testDir, scanner, false);
                    continue;
                }
                jarFile = new JarFile(contextDir);
                ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, false);
                continue;
            }
            if (!protocol.equals("jar")) continue;
            JarURLConnection jarc = (JarURLConnection)url.openConnection();
            jarFile = jarc.getJarFile();
            ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, false);
        }
        return result;
    }

    @Override
    public <T> T scanOneResource(ResourceLoader.MatchType matchType, ResourceLoader.Scanner<T> scanner, String[] scanPaths) throws IOException {
        ArrayList result = new ArrayList();
        Predicate<JarEntry>[] testJar = this.buildPredicate(matchType, scanPaths, ZipEntry::getName);
        Predicate<File>[] testDir = this.buildPredicate(matchType, scanPaths, File::getPath);
        for (URL url : this.classpath) {
            java.util.jar.JarFile jarFile;
            String protocol = url.getProtocol();
            if (protocol.equals("file")) {
                File contextDir = new File(URLDecoder.decode(url.getFile()));
                if (contextDir.isDirectory()) {
                    ClassPathResourceLoader.dirScan(result, contextDir, contextDir, testDir, scanner, true);
                } else {
                    jarFile = new JarFile(contextDir);
                    ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, true);
                }
            } else if (protocol.equals("jar")) {
                JarURLConnection jarc = (JarURLConnection)url.openConnection();
                jarFile = jarc.getJarFile();
                ClassPathResourceLoader.jarScan(result, jarFile, testJar, scanner, true);
            }
            if (result.isEmpty()) continue;
            return (T)result.get(0);
        }
        return null;
    }

    private static <T> void jarScan(List<T> result, java.util.jar.JarFile jarFile, Predicate<JarEntry>[] jarTest, ResourceLoader.Scanner<T> scanner, boolean matchOnce) throws IOException {
        URL content = new File(jarFile.getName()).toURI().toURL();
        Iterator zipEntry = jarFile.stream().iterator();
        while (zipEntry.hasNext()) {
            JarEntry entry = (JarEntry)zipEntry.next();
            if (!ClassPathResourceLoader.jarTestFound(entry, jarTest)) continue;
            URL url = new URL("jar:" + content + "!/" + entry.getName());
            ResourceLoader.InputStreamGet inputStream = () -> jarFile.getInputStream(entry);
            T res = scanner.found(new ResourceLoader.ScanEvent(entry.getName(), entry.getSize(), url, inputStream));
            if (res != null) {
                result.add(res);
            }
            if (!matchOnce || result.isEmpty()) continue;
            return;
        }
    }

    private static boolean jarTestFound(JarEntry entry, Predicate<JarEntry>[] jarTest) {
        if (jarTest == null || jarTest.length == 0) {
            return true;
        }
        for (Predicate<JarEntry> predicate : jarTest) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }

    private static <T> void dirScan(List<T> result, File contextDir, File curFile, Predicate<File>[] testDir, ResourceLoader.Scanner<T> scanner, boolean matchOnce) throws IOException {
        if (matchOnce && !result.isEmpty()) {
            return;
        }
        File[] listFiles = curFile.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File fileItem : listFiles) {
            if (matchOnce && !result.isEmpty()) {
                return;
            }
            if (fileItem.isHidden() || !fileItem.exists()) continue;
            if (fileItem.isDirectory()) {
                ClassPathResourceLoader.dirScan(result, contextDir, fileItem, testDir, scanner, matchOnce);
                continue;
            }
            String resourceName = fileItem.getAbsolutePath().substring(contextDir.getAbsolutePath().length() + 1);
            if (!ClassPathResourceLoader.dirTestFound(new File(resourceName), testDir)) continue;
            ResourceLoader.InputStreamGet inputStream = () -> {
                if (fileItem.canRead()) {
                    return new FileInputStream(fileItem);
                }
                throw new IOException("file cannot be read :" + fileItem);
            };
            T res = scanner.found(new ResourceLoader.ScanEvent(resourceName, fileItem.length(), fileItem.toURI().toURL(), inputStream));
            if (res == null) continue;
            result.add(res);
        }
    }

    private static boolean dirTestFound(File entry, Predicate<File>[] dirTest) {
        if (dirTest == null || dirTest.length == 0) {
            return true;
        }
        for (Predicate<File> predicate : dirTest) {
            if (!predicate.test(entry)) continue;
            return true;
        }
        return false;
    }
}

