/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import net.hasor.cobble.loader.ResourceLoader;

class InnerClassLoader
extends ClassLoader {
    private final String tempDirectory = "cobbleLoader/" + System.currentTimeMillis();
    private File tempDir;
    private final ResourceLoader resourceLoader;

    public InnerClassLoader(ClassLoader parent, ResourceLoader resourceLoader) {
        super(parent);
        this.resourceLoader = resourceLoader;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String resource = className.replace(".", "/") + ".class";
        try {
            InputStream inStream = this.resourceLoader.getResourceAsStream(resource);
            if (inStream != null) {
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                InnerClassLoader.ioCopy(inStream, byteOutput);
                byte[] bs = byteOutput.toByteArray();
                return this.defineClass(className, bs, 0, bs.length);
            }
        }
        catch (IOException e2) {
            throw new ClassNotFoundException(className, e2);
        }
        return super.findClass(className);
    }

    @Override
    protected URL findResource(String resource) {
        try {
            return this.resourceLoader.getResource(resource);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> findResources(String resource) throws IOException {
        ArrayList<URL> resultList = new ArrayList<URL>();
        List<URL> resources = this.resourceLoader.getResources(resource);
        if (resources != null) {
            resultList.addAll(resources);
        }
        final Iterator urlIterator = resultList.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return urlIterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)urlIterator.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        try {
            return this.resourceLoader.getResourceAsStream(resource);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    protected String findLibrary(String sLib) {
        try {
            File tempLib = this.findJarNativeEntry(sLib);
            if (tempLib != null) {
                return tempLib.getAbsolutePath();
            }
            return super.findLibrary(sLib);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File findJarNativeEntry(String sLib) throws IOException {
        String sName = System.mapLibraryName(sLib);
        File foundFile = this.resourceLoader.scanOneResource(ResourceLoader.MatchType.Suffix, event -> {
            String sEntry = event.getName();
            String[] token = sEntry.split("/");
            if (token.length > 0 && token[token.length - 1].equals(sName)) {
                File fileTmp = this.createTempFile(event);
                fileTmp.deleteOnExit();
                return fileTmp;
            }
            return null;
        }, new String[]{sName});
        if (foundFile != null && foundFile.exists()) {
            return foundFile;
        }
        return null;
    }

    private File createTempFile(ResourceLoader.ScanEvent inf) throws IOException {
        if (this.tempDir == null) {
            File dir = new File(System.getProperty("java.io.tmpdir"), this.tempDirectory);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.chmod777(dir);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException("Cannot create temp directory " + dir.getAbsolutePath());
            }
            this.tempDir = dir;
            this.tempDir.deleteOnExit();
        }
        File fileTmp = File.createTempFile(inf.getName() + ".", null, this.tempDir);
        fileTmp.deleteOnExit();
        this.chmod777(fileTmp);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileTmp));
             InputStream in = inf.getStream();){
            InnerClassLoader.ioCopy(in, out);
        }
        return fileTmp;
    }

    private static void ioCopy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }

    private void chmod777(File file) {
        file.setReadable(true, false);
        file.setWritable(true, false);
        file.setExecutable(true, false);
    }
}

