/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.loader;

import java.util.function.Function;
import java.util.function.Predicate;
import net.hasor.cobble.loader.InnerClassLoader;
import net.hasor.cobble.loader.ResourceLoader;

public abstract class AbstractResourceLoader
implements ResourceLoader {
    protected final ClassLoader parentClassLoader;
    private volatile InnerClassLoader innerClassLoader;

    public AbstractResourceLoader() {
        this.parentClassLoader = null;
    }

    public AbstractResourceLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    protected ResourceLoader loaderForClassLoader() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> getClass(String className) throws ClassNotFoundException {
        if (this.innerClassLoader == null) {
            AbstractResourceLoader abstractResourceLoader = this;
            synchronized (abstractResourceLoader) {
                if (this.innerClassLoader == null) {
                    this.innerClassLoader = new InnerClassLoader(this.parentClassLoader, this.loaderForClassLoader());
                }
            }
        }
        return this.innerClassLoader.loadClass(className);
    }

    protected <T> Predicate<T>[] buildPredicate(ResourceLoader.MatchType matchType, String[] scanPaths, Function<T, String> nameFunc) {
        if (matchType == null) {
            throw new IllegalStateException("missing matchType.");
        }
        Predicate[] tests = new Predicate[scanPaths.length];
        block8: for (int i = 0; i < scanPaths.length; ++i) {
            String matchExpr = scanPaths[i];
            switch (matchType) {
                case None: {
                    tests[i] = e -> true;
                    continue block8;
                }
                case Match: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).equals(matchExpr);
                    continue block8;
                }
                case Regex: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).matches(matchExpr);
                    continue block8;
                }
                case ContainsAny: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).contains(matchExpr);
                    continue block8;
                }
                case Prefix: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).startsWith(matchExpr);
                    continue block8;
                }
                case Suffix: {
                    tests[i] = e -> ((String)nameFunc.apply(e)).endsWith(matchExpr);
                    continue block8;
                }
                default: {
                    tests[i] = e -> false;
                }
            }
        }
        return tests;
    }
}

