/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.ref;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.cobble.CollectionUtils;

public class SpaceHashMap<K, T> {
    protected Map<String, Map<K, T>> spaceMap = new LinkedHashMap<String, Map<K, T>>();

    public T put(String space, K key, T value) {
        Map<K, T> spaceMap = this.spaceMap.get(space);
        if (spaceMap == null) {
            spaceMap = new ConcurrentHashMap<K, T>();
            this.spaceMap.put(space, spaceMap);
        }
        return spaceMap.put(key, value);
    }

    public void putAll(String space, Map<K, T> newMap) {
        Map<K, T> spaceMap = this.spaceMap.get(space);
        if (spaceMap == null) {
            spaceMap = new ConcurrentHashMap<K, T>();
            this.spaceMap.put(space, spaceMap);
        }
        spaceMap.putAll(newMap);
    }

    public List<T> get(K key) {
        ArrayList<T> findVal = new ArrayList<T>();
        for (Map<K, T> map : this.spaceMap.values()) {
            T val = map.get(key);
            if (val == null) continue;
            findVal.add(val);
        }
        return findVal;
    }

    public T get(String space, K key) {
        Map<K, T> map = this.spaceMap.get(space);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public T remove(String space, K key) {
        Map<K, T> spaceMap = this.spaceMap.get(space);
        if (spaceMap != null) {
            return spaceMap.remove(key);
        }
        return null;
    }

    public void removeAll(K key) {
        for (Map<K, T> mapItem : this.spaceMap.values()) {
            mapItem.remove(key);
        }
    }

    public Set<String> spaceSet() {
        return this.spaceMap.keySet();
    }

    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>();
        for (Map<K, T> mapItem : this.spaceMap.values()) {
            keys.addAll(mapItem.keySet());
        }
        return keys;
    }

    public Set<K> keySet(String space) {
        Map<K, T> map = this.spaceMap.get(space);
        if (map != null) {
            return map.keySet();
        }
        return new HashSet();
    }

    public void deleteSpace(String space) {
        this.spaceMap.remove(space);
    }

    public void deleteAllSpace() {
        this.spaceMap.clear();
    }

    public int size() {
        HashSet<K> keys = new HashSet<K>();
        for (Map<K, T> map : this.spaceMap.values()) {
            keys.addAll(map.keySet());
        }
        return keys.size();
    }

    public int size(String space) {
        Map<K, T> map = this.spaceMap.get(space);
        if (map == null) {
            return 0;
        }
        return map.size();
    }

    public SpaceHashMap<K, T> cloneSpace(String space) {
        SpaceHashMap<K, T> spaceMap = new SpaceHashMap<K, T>();
        Map<K, T> dataMap = this.spaceMap.get(space);
        if (dataMap != null) {
            spaceMap.putAll(space, dataMap);
        }
        return spaceMap;
    }

    public Set<T> valueSet() {
        HashSet<T> values = new HashSet<T>();
        for (Map<K, T> mapItem : this.spaceMap.values()) {
            values.addAll(mapItem.values());
        }
        return values;
    }

    public Set<T> valueSet(String space) {
        Map<K, T> dataMap = this.spaceMap.get(space);
        if (dataMap != null) {
            return new HashSet<T>(dataMap.values());
        }
        return new HashSet();
    }

    public Iterator<Map.Entry<K, T>> iterator() {
        Iterator<Map.Entry<K, T>> seqIterator = null;
        for (Map<K, T> mapItem : this.spaceMap.values()) {
            seqIterator = CollectionUtils.mergeIterator(seqIterator, mapItem.entrySet().iterator());
        }
        return seqIterator;
    }
}

