/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Callable;

public class ThreadUtils {
    private static final AtomicInteger globalCnt = new AtomicInteger(0);

    public static ThreadFactory daemonThreadFactory(ClassLoader loader) {
        return ThreadUtils.threadFactory(loader, "Thread-%s", true);
    }

    public static ThreadFactory daemonThreadFactory(ClassLoader loader, String nameTemplate) {
        return ThreadUtils.threadFactory(loader, nameTemplate, true);
    }

    public static ThreadFactory threadFactory(ClassLoader loader, String nameTemplate, boolean isDaemon) {
        String template = StringUtils.isBlank(nameTemplate) ? "Thread-%s" : nameTemplate;
        AtomicInteger cnt = new AtomicInteger(0);
        return run -> {
            Thread t = new Thread(run);
            if (loader != null) {
                t.setContextClassLoader(loader);
            }
            t.setName(String.format(template, cnt.incrementAndGet()));
            t.setDaemon(isDaemon);
            return t;
        };
    }

    private static Thread runnableRun(boolean run, Thread thread) {
        if (run) {
            thread.start();
        }
        return thread;
    }

    private static Thread runnableThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName(String.format("Thread-%s", globalCnt.incrementAndGet()));
        return thread;
    }

    private static Thread callableThread(Callable runnable) {
        Thread thread = new Thread(() -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntime(e);
            }
        });
        thread.setName(String.format("Thread-%s", globalCnt.incrementAndGet()));
        return thread;
    }

    public static Thread frontThread(boolean run, Runnable runnable) {
        Thread t = ThreadUtils.runnableThread(runnable);
        t.setDaemon(false);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread frontThread(boolean run, Callable runnable) {
        Thread t = ThreadUtils.callableThread(runnable);
        t.setDaemon(false);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread frontThread(boolean run, ClassLoader loader, Runnable runnable) {
        Thread t = ThreadUtils.runnableThread(runnable);
        t.setDaemon(false);
        t.setContextClassLoader(loader);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread frontThread(boolean run, ClassLoader loader, Callable runnable) {
        Thread t = ThreadUtils.callableThread(runnable);
        t.setDaemon(false);
        t.setContextClassLoader(loader);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread daemonThread(boolean run, Runnable runnable) {
        Thread t = ThreadUtils.runnableThread(runnable);
        t.setDaemon(true);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread daemonThread(boolean run, Callable runnable) {
        Thread t = ThreadUtils.callableThread(runnable);
        t.setDaemon(true);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread daemonThread(boolean run, ClassLoader loader, Runnable runnable) {
        Thread t = ThreadUtils.runnableThread(runnable);
        t.setDaemon(true);
        t.setContextClassLoader(loader);
        return ThreadUtils.runnableRun(run, t);
    }

    public static Thread daemonThread(boolean run, ClassLoader loader, Callable runnable) {
        Thread t = ThreadUtils.callableThread(runnable);
        t.setDaemon(true);
        t.setContextClassLoader(loader);
        return ThreadUtils.runnableRun(run, t);
    }

    public static ExecutorService daemonFixedThreadPool(ClassLoader loader, int nThreads) {
        ThreadFactory threadFactory = ThreadUtils.threadFactory(loader, "Thread-%s", true);
        return Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public static ExecutorService frontFixedThreadPool(ClassLoader loader, int nThreads) {
        ThreadFactory threadFactory = ThreadUtils.threadFactory(loader, "Thread-%s", false);
        return Executors.newFixedThreadPool(nThreads, threadFactory);
    }

    public static void sleep(long interval, TimeUnit timeUnit) {
        if (interval <= 0L) {
            return;
        }
        try {
            Thread.sleep(timeUnit.toMillis(interval));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long intervalMillis) {
        if (intervalMillis <= 0L) {
            return;
        }
        try {
            Thread.sleep(intervalMillis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

