/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.input.AutoCloseInputStream;

public class ResourcesUtils {
    public static String formatResource(String resourcePath) {
        if (resourcePath != null && resourcePath.length() > 1 && resourcePath.charAt(0) == '/') {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    private static ClassLoader getCurrentLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Map<String, String> getProperty(String[] resourcePaths) throws IOException {
        return ResourcesUtils.getProperty(Arrays.asList(resourcePaths).iterator());
    }

    public static Map<String, String> getProperty(Iterator<String> iterator) throws IOException {
        if (iterator == null) {
            return null;
        }
        ClassLoader classLoader = ResourcesUtils.getCurrentLoader();
        HashMap<String, String> fullData = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String str = iterator.next();
            Map<String, String> att = ResourcesUtils.getProperty(classLoader, str);
            fullData.putAll(att);
        }
        return fullData;
    }

    public static Map<String, String> getProperty(String resourcePath) throws IOException {
        return ResourcesUtils.getProperty(ResourcesUtils.getCurrentLoader(), resourcePath);
    }

    public static Map<String, String> getProperty(ClassLoader classLoader, String resourcePath) throws IOException {
        Properties prop = new Properties();
        InputStream in = ResourcesUtils.getResourceAsStream(classLoader, resourcePath);
        if (in != null) {
            prop.load(in);
        }
        HashMap<String, String> resultData = new HashMap<String, String>();
        for (Object keyObj : prop.keySet()) {
            String key = (String)keyObj;
            String val = prop.getProperty(key);
            resultData.put(key, val);
        }
        return resultData;
    }

    public static URL getResource(String resourcePath) throws IOException {
        if (StringUtils.isBlank(resourcePath)) {
            return null;
        }
        if (resourcePath.startsWith("classpath:")) {
            resourcePath = resourcePath.substring("classpath:".length());
            return ResourcesUtils.getResource(ResourcesUtils.getCurrentLoader(), resourcePath);
        }
        if (resourcePath.startsWith("http:") || resourcePath.startsWith("https:") || resourcePath.startsWith("file:") || resourcePath.startsWith("jar:") || resourcePath.startsWith("ftp:")) {
            return new URL(resourcePath);
        }
        return ResourcesUtils.getResource(ResourcesUtils.getCurrentLoader(), resourcePath);
    }

    public static URL getResource(ClassLoader classLoader, String resourcePath) throws IOException {
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        return classLoader.getResource(resourcePath);
    }

    public static List<URL> getResources(String resourcePath) throws IOException {
        return ResourcesUtils.getResources(ResourcesUtils.getCurrentLoader(), resourcePath);
    }

    public static List<URL> getResources(ClassLoader classLoader, String resourcePath) throws IOException {
        if (resourcePath == null) {
            return new ArrayList<URL>(0);
        }
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnumeration = classLoader.getResources(resourcePath);
        while (urlEnumeration.hasMoreElements()) {
            URL url = urlEnumeration.nextElement();
            urls.add(url);
        }
        return urls;
    }

    public static InputStream getResourceAsStream(File resourceFile) throws IOException {
        return ResourcesUtils.getResourceAsStream(ResourcesUtils.getCurrentLoader(), resourceFile.toURI().toURL());
    }

    public static InputStream getResourceAsStream(URI resourceURI) throws IOException {
        return ResourcesUtils.getResourceAsStream(ResourcesUtils.getCurrentLoader(), resourceURI.toURL());
    }

    public static InputStream getResourceAsStream(String resourcePath) throws IOException {
        URL resource = ResourcesUtils.getResource(resourcePath);
        if (resource == null) {
            return null;
        }
        return ResourcesUtils.getResourceAsStream(ResourcesUtils.getCurrentLoader(), resource);
    }

    public static InputStream getResourceAsStream(URL resourceURL) throws IOException {
        return ResourcesUtils.getResourceAsStream(ResourcesUtils.getCurrentLoader(), resourceURL);
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, URI resourceURI) throws IOException {
        return ResourcesUtils.getResourceAsStream(classLoader, resourceURI.toURL());
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String resourcePath) throws IOException {
        URL resource;
        resourcePath = ResourcesUtils.formatResource(resourcePath);
        if (classLoader != null) {
            resource = classLoader.getResource(resourcePath);
        } else {
            classLoader = ResourcesUtils.getCurrentLoader();
            resource = ResourcesUtils.getResource(resourcePath);
        }
        if (resource == null) {
            return null;
        }
        return ResourcesUtils.getResourceAsStream(classLoader, resource);
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, URL resourceURL) throws IOException {
        String protocol;
        switch (protocol = resourceURL.getProtocol().trim().toLowerCase()) {
            case "http": 
            case "https": 
            case "ftp": {
                return new AutoCloseInputStream(resourceURL.openStream());
            }
            case "file": {
                String substring = resourceURL.toString().substring(5);
                File targetFile = new File(substring);
                if (targetFile.exists()) {
                    if (targetFile.canRead() && targetFile.isFile()) {
                        return new AutoCloseInputStream(Files.newInputStream(targetFile.toPath(), new OpenOption[0]));
                    }
                    throw new IOException("resource " + targetFile.getAbsolutePath() + " can not be read.");
                }
                return null;
            }
            case "jar": {
                JarFile jar = ((JarURLConnection)resourceURL.openConnection()).getJarFile();
                String jarFile = jar.getName().replace("\\", "/");
                String resourcePath = URLDecoder.decode(resourceURL.getPath(), "utf-8");
                int beginIndex = resourcePath.indexOf(jarFile) + jarFile.length();
                String entPath = resourcePath.substring(beginIndex + 2);
                ZipEntry e = jar.getEntry(entPath);
                return new AutoCloseInputStream(jar.getInputStream(e));
            }
            case "classpath": {
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                String resource = ResourcesUtils.formatResource(resourceURL.toString().substring(10));
                return classLoader.getResourceAsStream(resource);
            }
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader.getResourceAsStream(resourceURL.toString());
    }

    public static List<InputStream> getResourceAsStreamList(String resourcePath) throws IOException {
        return ResourcesUtils.getResourceAsStreamList(ResourcesUtils.getCurrentLoader(), resourcePath);
    }

    public static List<InputStream> getResourceAsStreamList(ClassLoader classLoader, String resourcePath) throws IOException {
        ArrayList<InputStream> iss = new ArrayList<InputStream>();
        List<URL> urls = ResourcesUtils.getResources(classLoader, resourcePath);
        for (URL url : urls) {
            InputStream in = ResourcesUtils.getResourceAsStream(classLoader, url);
            if (in == null) continue;
            iss.add(new AutoCloseInputStream(in));
        }
        return iss;
    }

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        return ResourcesUtils.classForName(ResourcesUtils.getCurrentLoader(), className);
    }

    public static Class<?> classForName(ClassLoader loader, String className) throws ClassNotFoundException {
        if (loader == null) {
            return ResourcesUtils.getCurrentLoader().loadClass(className);
        }
        return loader.loadClass(className);
    }
}

