/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.hasor.cobble.concurrent.future;
import java.util.EventListener;
import java.util.concurrent.Future;

/**
 *
 * @version : 2014年11月15日
 * @author 赵永春 (zyc@hasor.net)
 */
@FunctionalInterface
public interface FutureListener<F extends Future<?>> extends EventListener {
    /**
     * Invoked when the operation associated with the {@link Future} has been completed.
     * @param future  the source {@link Future} which called this callback
     */
    void operationComplete(F future);
}