/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.ref;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.hasor.cobble.RandomUtils;
import net.hasor.cobble.ref.Range;

public class RandomRatio<T> {
    private final List<Boundary<T>> opsBoundary = new CopyOnWriteArrayList<Boundary<T>>();
    private volatile long maxBoundary = 0L;

    private long maxBoundary(List<Boundary<T>> opsBoundary) {
        Boundary boundary = opsBoundary.stream().max(Comparator.comparingLong(Range::getMaximum)).orElse(null);
        return boundary != null ? (Long)boundary.getMaximum() : 0L;
    }

    public synchronized void clearRatio() {
        this.opsBoundary.clear();
        this.maxBoundary = 0L;
    }

    public synchronized void addRatio(int ratio, T value) {
        this.opsBoundary.add(new Boundary<T>(value, this.maxBoundary, this.maxBoundary + (long)ratio));
        this.maxBoundary = this.maxBoundary(this.opsBoundary);
    }

    private long getMaxBoundary() {
        return this.maxBoundary;
    }

    public T getByBoundary(long boundaryNumber) {
        for (Boundary<T> entry : this.opsBoundary) {
            if ((Long)entry.getMinimum() > boundaryNumber || boundaryNumber > (Long)entry.getMaximum()) continue;
            return entry.getValue();
        }
        return null;
    }

    public T getByIndex(int index) {
        return this.opsBoundary.get(index).getValue();
    }

    public T getLast() {
        if (this.opsBoundary.isEmpty()) {
            return null;
        }
        return this.opsBoundary.get(this.opsBoundary.size() - 1).getValue();
    }

    public T getFirst() {
        if (this.opsBoundary.isEmpty()) {
            return null;
        }
        return this.opsBoundary.get(0).getValue();
    }

    public T getByRandom() {
        return this.getByBoundary(RandomUtils.nextLong(0L, this.maxBoundary));
    }

    public boolean isEmpty() {
        return this.opsBoundary.isEmpty();
    }

    public int getBoundaryCount() {
        return this.opsBoundary.size();
    }

    public void forEach(Consumer<T> action) {
        Objects.requireNonNull(action);
        for (Boundary<T> t : this.opsBoundary) {
            action.accept(((Boundary)t).value);
        }
    }

    protected static class Boundary<V>
    extends Range<Long> {
        private final V value;

        public Boundary(V value, long lower, long upper) {
            super(lower, upper, Long::compare);
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Boundary boundary = (Boundary)o;
            return boundary.value == this.value && super.equals(boundary);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.getMinimum(), this.getMaximum());
        }
    }
}

