/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.convert.convert;

import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.convert.ConversionException;
import net.hasor.cobble.convert.convert.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        this.setDefaultValue(defaultValue);
    }

    @Override
    protected Class<?> getDefaultType() {
        return Boolean.class;
    }

    @Override
    protected Object convertToType(Class<?> type, Object value) throws Throwable {
        String stringValue = value.toString().toLowerCase();
        if ("".equals(stringValue)) {
            return BeanUtils.getDefaultValue(type);
        }
        for (String trueString : this.trueStrings) {
            if (!trueString.equals(stringValue)) continue;
            return Boolean.TRUE;
        }
        for (String falseString : this.falseStrings) {
            if (!falseString.equals(stringValue)) continue;
            return Boolean.FALSE;
        }
        throw new ConversionException("Can't convert value '" + value + "' to a Boolean");
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }
}

