/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.convert.convert;

import java.lang.reflect.Array;
import java.util.Collection;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.convert.ConversionException;
import net.hasor.cobble.convert.Converter;

public abstract class AbstractConverter
implements Converter {
    private boolean useDefault = false;
    private Object defaultValue = null;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Override
    public Object convert(Class<?> type, Object value) {
        Class<?> sourceType = value == null ? null : value.getClass();
        if ((value = this.convertArray(value)) == null) {
            return this.handleMissing(type);
        }
        sourceType = value.getClass();
        try {
            if (type.equals(String.class)) {
                return this.convertToString(value);
            }
            if (type.equals(sourceType)) {
                return value;
            }
            return this.convertToType(type, value);
        }
        catch (Throwable t) {
            return this.handleError(type, value, t);
        }
    }

    protected Object handleError(Class<?> type, Object value, Throwable cause) {
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        if (cause instanceof ConversionException) {
            throw (ConversionException)cause;
        }
        String msg = "Error converting from '" + value.getClass() + "' to '" + type + "' " + cause.getMessage();
        throw new ConversionException(msg, cause);
    }

    protected String convertToString(Object value) throws Throwable {
        return value.toString();
    }

    protected abstract Object convertToType(Class<?> var1, Object var2) throws Throwable;

    protected Object convertArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (Array.getLength(value) > 0) {
                return Array.get(value, 0);
            }
            return null;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class<?> getDefaultType();

    protected Object getDefault(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    protected Object handleMissing(Class<?> type) {
        if (this.useDefault || type.equals(String.class)) {
            Object value = this.getDefault(type);
            if (this.useDefault && value != null && !type.equals(value.getClass())) {
                try {
                    value = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return value;
        }
        return BeanUtils.getDefaultValue(type);
    }

    public String toString(Class<?> type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        String PACKAGE = AbstractConverter.class.getPackage().getName() + ".";
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }
}

