/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.bus;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.bus.BusCaller;
import net.hasor.cobble.bus.BusContext;
import net.hasor.cobble.bus.BusListener;
import net.hasor.cobble.bus.ListenerPool;
import net.hasor.cobble.concurrent.future.BasicFuture;

public class EventBus
implements BusContext {
    private final ConcurrentMap<String, ListenerPool> listenerMap = new ConcurrentHashMap<String, ListenerPool>();

    private ListenerPool getOrCreateListenerPool(String event) {
        ListenerPool newPool;
        ListenerPool pool = (ListenerPool)this.listenerMap.get(event);
        if (pool == null && (pool = this.listenerMap.putIfAbsent(event, newPool = new ListenerPool())) == null) {
            pool = newPool;
        }
        return pool;
    }

    private ListenerPool getListenerPool(String event) {
        return (ListenerPool)this.listenerMap.get(event);
    }

    @Override
    public boolean pushListener(String event, BusListener eventListener) {
        if (StringUtils.isBlank(event) || eventListener == null) {
            return false;
        }
        return this.getOrCreateListenerPool(event).pushOnceListener(eventListener);
    }

    @Override
    public boolean addListener(String event, BusListener eventListener) {
        if (StringUtils.isBlank(event) || eventListener == null) {
            return false;
        }
        return this.getOrCreateListenerPool(event).addListener(eventListener);
    }

    @Override
    public boolean removeListener(String event, BusListener eventListener) {
        if (StringUtils.isBlank(event) || eventListener == null) {
            return false;
        }
        ListenerPool listenerPool = this.getListenerPool(event);
        if (listenerPool != null) {
            return listenerPool.removeListener(eventListener);
        }
        return false;
    }

    @Override
    public void clearAllListener() {
        this.listenerMap.clear();
    }

    @Override
    public void clearListener(String event) {
        if (StringUtils.isBlank(event)) {
            return;
        }
        ListenerPool listenerPool = this.getListenerPool(event);
        if (listenerPool != null) {
            this.getListenerPool(event).clearListener();
        }
    }

    @Override
    public void fireEvent(String event, Object data) throws Throwable {
        this.fireEvent(event, data, (listener, lastResult) -> {
            listener.onEvent(event, data);
            return null;
        });
    }

    @Override
    public Object fireEvent(String event, Object data, BusCaller caller) throws Throwable {
        ListenerPool listenerPool = this.getListenerPool(event);
        if (listenerPool == null) {
            return null;
        }
        Object lastResult = null;
        List<BusListener> snapshot = listenerPool.getListenerSnapshot();
        for (BusListener item : snapshot) {
            lastResult = caller.doEvent(item, lastResult);
        }
        List<BusListener> onceList = listenerPool.popOnceListener();
        if (onceList != null) {
            for (BusListener item : onceList) {
                lastResult = caller.doEvent(item, lastResult);
            }
        }
        return lastResult;
    }

    @Override
    public void fireEventWithoutThrow(String event, Object data) {
        this.fireEventWithoutThrow(event, data, (listener, lastResult) -> {
            listener.onEvent(event, data);
            return null;
        });
    }

    @Override
    public Object fireEventWithoutThrow(String event, Object data, BusCaller caller) {
        ListenerPool listenerPool = this.getListenerPool(event);
        if (listenerPool == null) {
            return null;
        }
        Object lastResult = null;
        List<BusListener> snapshot = listenerPool.getListenerSnapshot();
        for (BusListener item : snapshot) {
            try {
                lastResult = caller.doEvent(item, lastResult);
            }
            catch (Throwable throwable) {}
        }
        List<BusListener> onceList = listenerPool.popOnceListener();
        if (onceList != null) {
            for (BusListener item : onceList) {
                try {
                    lastResult = caller.doEvent(item, lastResult);
                }
                catch (Throwable throwable) {}
            }
        }
        return lastResult;
    }

    @Override
    public Future<Void> asyncFireEvent(Executor executor, String event, Object args) {
        BasicFuture<Void> future = new BasicFuture<Void>();
        executor.execute(() -> {
            try {
                if (!future.isCancelled()) {
                    this.fireEvent(event, args);
                    future.completed(null);
                }
            }
            catch (Throwable e) {
                future.failed(e);
            }
        });
        return future;
    }

    @Override
    public Future<Object> asyncFireEvent(Executor executor, String event, Object args, BusCaller caller) {
        BasicFuture<Object> future = new BasicFuture<Object>();
        executor.execute(() -> {
            try {
                if (!future.isCancelled()) {
                    Object result = this.fireEvent(event, args, caller);
                    future.completed(result);
                }
            }
            catch (Throwable e) {
                future.failed(e);
            }
        });
        return future;
    }

    @Override
    public Future<Void> lazyFireEvent(Executor executor, String event, Object args, long sleep, TimeUnit timeUnit) {
        BasicFuture<Void> future = new BasicFuture<Void>();
        executor.execute(() -> {
            try {
                timeUnit.sleep(sleep);
                if (!future.isCancelled()) {
                    this.fireEvent(event, args);
                    future.completed(null);
                }
            }
            catch (Throwable e) {
                future.failed(e);
            }
        });
        return future;
    }

    @Override
    public Future<Object> lazyFireEvent(Executor executor, String event, Object args, BusCaller caller, long sleep, TimeUnit timeUnit) {
        BasicFuture<Object> future = new BasicFuture<Object>();
        executor.execute(() -> {
            try {
                timeUnit.sleep(sleep);
                if (!future.isCancelled()) {
                    Object result = this.fireEvent(event, args, caller);
                    future.completed(result);
                }
            }
            catch (Throwable e) {
                future.failed(e);
            }
        });
        return future;
    }
}

