/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.ref.BufferedIterator;
import net.hasor.cobble.reflect.SFunction;

public class CollectionUtils {
    public static boolean isNotEmpty(Collection<?> tables) {
        return tables != null && !tables.isEmpty();
    }

    public static boolean isEmpty(Collection<?> tables) {
        return tables == null || tables.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> maps) {
        return maps != null && !maps.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> maps) {
        return maps == null || maps.isEmpty();
    }

    public static int size(Collection<?> list) {
        return list == null || list.isEmpty() ? 0 : list.size();
    }

    public static int size(Map<?, ?> map) {
        return map == null || map.isEmpty() ? 0 : map.size();
    }

    public static <T> List<List<T>> splitList(List<T> sourceList, int groupSize) {
        int length = sourceList.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<T>> newList = new ArrayList<List<T>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = Math.min((i + 1) * groupSize, length);
            newList.add(sourceList.subList(fromIndex, toIndex));
        }
        return newList;
    }

    public static <T> BufferedIterator<T> bufferedIterator(Iterator<T> oriIterator, int bufferedSize) {
        return new BufferedIterator<T>(oriIterator, bufferedSize);
    }

    public static <T, O> Iterator<O> convertIterator(final Iterator<T> oriIterator, final Function<T, O> converter) {
        return new Iterator<O>(){

            @Override
            public void remove() {
                oriIterator.remove();
            }

            @Override
            public O next() {
                return converter.apply(oriIterator.next());
            }

            @Override
            public boolean hasNext() {
                return oriIterator.hasNext();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(List<T> list) {
        return list == null ? null : CollectionUtils.asEnumeration(list.iterator());
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> List<T> asList(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    public static <T> List<T> asList(T ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, arrays);
        return arrayList;
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1) {
        return CollectionUtils.asMap(key1, val1, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2) {
        return CollectionUtils.asMap(key1, val1, key2, val2, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, null, null, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, key6, val6, null, null, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6, K key7, V val7) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, key6, val6, key7, val7, null, null, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6, K key7, V val7, K key8, V val8) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, key6, val6, key7, val7, key8, val8, null, null, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6, K key7, V val7, K key8, V val8, K key9, V val9) {
        return CollectionUtils.asMap(key1, val1, key2, val2, key3, val3, key4, val4, key5, val5, key6, val6, key7, val7, key8, val8, key9, val9, null, null);
    }

    public static <K, V> Map<K, V> asMap(K key1, V val1, K key2, V val2, K key3, V val3, K key4, V val4, K key5, V val5, K key6, V val6, K key7, V val7, K key8, V val8, K key9, V val9, K key0, V val0) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (key1 != null) {
            map.put(key1, val1);
        }
        if (key2 != null) {
            map.put(key2, val2);
        }
        if (key3 != null) {
            map.put(key3, val3);
        }
        if (key4 != null) {
            map.put(key4, val4);
        }
        if (key5 != null) {
            map.put(key5, val5);
        }
        if (key6 != null) {
            map.put(key6, val6);
        }
        if (key7 != null) {
            map.put(key7, val7);
        }
        if (key8 != null) {
            map.put(key8, val8);
        }
        if (key9 != null) {
            map.put(key9, val9);
        }
        if (key0 != null) {
            map.put(key0, val0);
        }
        return map;
    }

    public static <T> Enumeration<T> mergeEnumeration(Enumeration<T> enum1, Enumeration<T> enum2) {
        final Enumeration<T> i1 = enum1 != null ? enum1 : CollectionUtils.asEnumeration(Collections.emptyIterator());
        final Enumeration<T> i2 = enum2 != null ? enum2 : CollectionUtils.asEnumeration(Collections.emptyIterator());
        return new Enumeration<T>(){
            private Enumeration<T> it;
            {
                this.it = i1;
            }

            @Override
            public boolean hasMoreElements() {
                return i1.hasMoreElements() || i2.hasMoreElements();
            }

            @Override
            public T nextElement() {
                if (!this.it.hasMoreElements()) {
                    this.it = i2;
                }
                return this.it.nextElement();
            }
        };
    }

    public static <T> Iterator<T> mergeIterator(Iterator<T> iterator1, Iterator<T> iterator2) {
        final Iterator<T> i1 = iterator1 != null ? iterator1 : Collections.emptyIterator();
        final Iterator<T> i2 = iterator2 != null ? iterator2 : Collections.emptyIterator();
        return new Iterator<T>(){
            private Iterator<T> it;
            {
                this.it = i1;
            }

            @Override
            public boolean hasNext() {
                return i1.hasNext() || i2.hasNext();
            }

            @Override
            public T next() {
                if (!this.it.hasNext()) {
                    this.it = i2;
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    public static boolean isEmpty(Object[] args) {
        return args == null || args.length == 0;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (coll1.size() < coll2.size()) {
            for (Object o : coll1) {
                if (!coll2.contains(o)) continue;
                return true;
            }
        } else {
            for (Object o : coll2) {
                if (!coll1.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> List<T> toTree(List<T> dataList, SFunction<T> children, SFunction<T> treeID, SFunction<T> parent) {
        if (dataList.isEmpty()) {
            return dataList;
        }
        Class<?> type = dataList.get(0).getClass();
        Property childrenField = BeanUtils.getPropertyFunc(type, BeanUtils.toProperty(children));
        Property treeIdField = BeanUtils.getPropertyFunc(type, BeanUtils.toProperty(treeID));
        Property parentField = BeanUtils.getPropertyFunc(type, BeanUtils.toProperty(parent));
        return CollectionUtils.toPidTree(dataList, childrenField, treeIdField, parentField, o -> o);
    }

    public static List<Map<String, Object>> toTree(List<Map<String, Object>> dataList, String children, String treeID, String parent) {
        if (dataList.isEmpty()) {
            return dataList;
        }
        Property childrenField = BeanUtils.getPropertyFunc(Map.class, children);
        Property treeIdField = BeanUtils.getPropertyFunc(Map.class, treeID);
        Property parentField = BeanUtils.getPropertyFunc(Map.class, parent);
        return CollectionUtils.toPidTree(dataList, childrenField, treeIdField, parentField, o -> o);
    }

    public static <T> List<T> toTree(List<T> dataList, SFunction<T> children, SFunction<T> pathCode) {
        if (dataList.isEmpty()) {
            return dataList;
        }
        Class<?> type = dataList.get(0).getClass();
        Property childrenField = BeanUtils.getPropertyFunc(type, BeanUtils.toProperty(children));
        Property pathCodeField = BeanUtils.getPropertyFunc(type, BeanUtils.toProperty(pathCode));
        return CollectionUtils.toPathTree(dataList, childrenField, pathCodeField, o -> o);
    }

    public static List<Map<String, Object>> toTree(List<Map<String, Object>> dataList, String children, String pathCode) {
        if (dataList.isEmpty()) {
            return dataList;
        }
        Property childrenField = BeanUtils.getPropertyFunc(Map.class, children);
        Property pathCodeField = BeanUtils.getPropertyFunc(Map.class, pathCode);
        return CollectionUtils.toPathTree(dataList, childrenField, pathCodeField, o -> o);
    }

    private static <I, O> List<O> toPidTree(List<I> dataList, Property childrenField, Property treeIdField, Property parentField, Function<I, O> convert) {
        if (treeIdField == null || parentField == null || childrenField == null || childrenField.isReadOnly()) {
            throw new IllegalArgumentException("[treeID, parent, children] not exist or children is readOnly.");
        }
        LinkedHashMap<Object, I> dataMap = new LinkedHashMap<Object, I>();
        for (I node : dataList) {
            Object tid = treeIdField.get(node);
            if (tid == null) {
                throw new IllegalArgumentException(" treeID is null.");
            }
            dataMap.put(tid, node);
        }
        HashSet<Object> needRemove = new HashSet<Object>();
        for (I node : dataList) {
            Object tid = treeIdField.get(node);
            Object parentId = parentField.get(node);
            if (parentId == null || !dataMap.containsKey(parentId)) continue;
            Object parentData = dataMap.get(parentId);
            ArrayList<I> childrenList = (ArrayList<I>)childrenField.get(parentData);
            if (childrenList == null) {
                childrenList = new ArrayList<I>();
                childrenField.set(parentData, childrenList);
            }
            childrenList.add(node);
            needRemove.add(tid);
        }
        for (Object remove : needRemove) {
            dataMap.remove(remove);
        }
        return dataMap.values().stream().map(convert).collect(Collectors.toList());
    }

    private static <I, O> List<O> toPathTree(List<I> dataList, Property childrenField, Property pathCodeField, Function<I, O> convert) {
        if (pathCodeField == null || childrenField == null || childrenField.isReadOnly()) {
            throw new IllegalArgumentException("[pathCode, children] not exist or children is readOnly.");
        }
        List sortedList = dataList.stream().sorted((o1, o2) -> {
            Object o1Path = pathCodeField.get(o1);
            Object o2Path = pathCodeField.get(o2);
            String o1PathStr = o1Path == null ? "" : o1Path.toString();
            String o2PathStr = o2Path == null ? "" : o2Path.toString();
            return o1PathStr.compareTo(o2PathStr);
        }).collect(Collectors.toList());
        ArrayList<String> allPathList = new ArrayList<String>();
        HashMap<String, List> allPathMap = new HashMap<String, List>();
        for (Object item : sortedList) {
            ArrayList list;
            String pathStr;
            Object path = pathCodeField.get(item);
            String string = pathStr = path == null ? null : path.toString();
            if (StringUtils.isBlank(pathStr)) {
                allPathMap.computeIfAbsent(pathStr, k -> new ArrayList()).add(item);
                continue;
            }
            String parentPath = null;
            for (String pItem : allPathList) {
                if (!StringUtils.startsWith(pathStr, pItem) || StringUtils.equals(pathStr, pItem)) continue;
                parentPath = pItem;
                break;
            }
            if (parentPath != null) {
                List parentList = (List)allPathMap.get(parentPath);
                Object parent = parentList.get(0);
                ArrayList childrenList = (ArrayList)childrenField.get(parent);
                if (childrenList == null) {
                    childrenList = new ArrayList();
                    childrenField.set(parent, childrenList);
                }
                CollectionUtils.insertOrAppend(dataList, childrenList, item);
                continue;
            }
            if (allPathMap.containsKey(pathStr)) {
                list = (ArrayList)allPathMap.get(pathStr);
                list.add(item);
                continue;
            }
            allPathList.add(0, pathStr);
            list = new ArrayList();
            list.add(item);
            allPathMap.put(pathStr, list);
        }
        ArrayList result = new ArrayList();
        for (List nodeList : allPathMap.values()) {
            for (Object node : nodeList) {
                CollectionUtils.insertOrAppend(dataList, result, convert.apply(node));
            }
        }
        return result;
    }

    private static void insertOrAppend(List oriData, List waitInsert, Object item) {
        int pos = waitInsert.size();
        int pubPos = oriData.indexOf(item);
        for (Object obj : waitInsert) {
            int newPos;
            int objPubPos = oriData.indexOf(obj);
            if (pubPos >= objPubPos || (newPos = waitInsert.indexOf(obj)) >= pos) continue;
            pos = newPos;
        }
        waitInsert.add(pos, item);
    }
}

