/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.ref;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class BufferedIterator<T>
implements Iterator<T> {
    private final Iterator<T> dataIterator;
    private final LinkedList<T> bufferedData;
    private final int bufferedSize;
    private int readIndex = 0;
    private boolean marked = false;

    public BufferedIterator(Iterator<T> iterator) {
        this(iterator, 4096);
    }

    public BufferedIterator(Iterator<T> dataIterator, int bufferedSize) {
        this.dataIterator = dataIterator;
        this.bufferedSize = bufferedSize;
        this.bufferedData = new LinkedList();
    }

    public void reset() {
        if (!this.marked) {
            throw new IllegalStateException("no marked to reset.");
        }
        this.readIndex = 0;
    }

    public void mark() {
        this.release();
        this.marked = true;
    }

    public void release() {
        this.marked = false;
        this.bufferedData.clear();
        this.readIndex = 0;
    }

    protected void checkSize() {
        if (this.readIndex >= this.bufferedSize) {
            throw new IndexOutOfBoundsException("out of buffered size " + this.bufferedSize);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.marked) {
            return this.readIndex < this.bufferedData.size() || this.dataIterator.hasNext();
        }
        return this.dataIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.marked) {
            if (this.readIndex < this.bufferedData.size()) {
                try {
                    T t = this.bufferedData.get(this.readIndex);
                    return t;
                }
                finally {
                    ++this.readIndex;
                }
            }
            this.checkSize();
            if (this.dataIterator.hasNext()) {
                T nextData = this.dataIterator.next();
                this.bufferedData.addLast(nextData);
                ++this.readIndex;
                return nextData;
            }
            throw new NoSuchElementException("no more data.");
        }
        return this.dataIterator.next();
    }
}

