/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.provider;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.hasor.cobble.provider.Provider;

public class SingleProvider<T>
implements Provider<T> {
    private Provider<T> provider = null;
    private volatile T instance = null;
    private final Object lock = new Object();

    public SingleProvider(T instance) {
        this.instance = instance;
    }

    public SingleProvider(Provider<T> provider) {
        this.provider = provider;
    }

    public SingleProvider(Supplier<T> supplier) {
        this.provider = supplier::get;
    }

    public SingleProvider(Callable<T> callable) {
        this.provider = callable::call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws Exception {
        if (this.instance == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.instance == null) {
                    this.instance = this.newInstance(this.provider);
                }
            }
        }
        return this.instance;
    }

    protected T newInstance(Supplier<T> provider) {
        return provider.get();
    }

    public String toString() {
        return "SingleProvider->" + this.provider.toString();
    }
}

