/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.provider;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.provider.InstanceProvider;
import net.hasor.cobble.provider.LoaderSingleProvider;
import net.hasor.cobble.provider.SingleProvider;
import net.hasor.cobble.provider.ThreadSingleProvider;

@FunctionalInterface
public interface Provider<T>
extends Supplier<T>,
Callable<T> {
    @Override
    default public T get() {
        try {
            return this.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    @Override
    public T call() throws Exception;

    default public Provider<T> asSingle() {
        if (this instanceof SingleProvider) {
            return this;
        }
        return new SingleProvider(this);
    }

    default public Provider<T> asThread() {
        if (this instanceof ThreadSingleProvider) {
            return this;
        }
        return new ThreadSingleProvider(this);
    }

    default public Provider<T> asLoader() {
        if (this instanceof LoaderSingleProvider) {
            return this;
        }
        return new LoaderSingleProvider(this);
    }

    public static <T> Provider<T> of(T instance) {
        return new SingleProvider<T>(instance);
    }

    public static <T> Provider<T> of(Supplier<T> supplier) {
        return supplier::get;
    }

    public static <T> Provider<T> of(Callable<T> callable) {
        return callable::call;
    }

    public static <T> Provider<T> wrap(T target) {
        return new InstanceProvider<T>(target);
    }

    public static <T> Provider<T> asThread(T target) {
        return new ThreadSingleProvider<T>(target);
    }

    public static <T> Provider<T> asLoader(T target) {
        return new LoaderSingleProvider<T>(target);
    }

    public static <T> Provider<T> toSingle(Supplier<T> supplier) {
        if (supplier instanceof SingleProvider || supplier instanceof InstanceProvider) {
            return (Provider)supplier;
        }
        return new SingleProvider<T>(supplier);
    }

    public static <T> Provider<T> toThread(Supplier<T> supplier) {
        if (supplier instanceof ThreadSingleProvider) {
            return (Provider)supplier;
        }
        return new ThreadSingleProvider<T>(supplier);
    }

    public static <T> Provider<T> toLoader(Supplier<T> supplier) {
        if (supplier instanceof LoaderSingleProvider) {
            return (Provider)supplier;
        }
        return new LoaderSingleProvider<T>(supplier);
    }

    public static <T> Provider<T> toSingle(Callable<T> callable) {
        if (callable instanceof SingleProvider || callable instanceof InstanceProvider) {
            return (Provider)callable;
        }
        return new SingleProvider<T>(callable);
    }

    public static <T> Provider<T> toThread(Callable<T> callable) {
        if (callable instanceof ThreadSingleProvider) {
            return (Provider)callable;
        }
        return new ThreadSingleProvider<T>(callable);
    }

    public static <T> Provider<T> toLoader(Callable<T> callable) {
        if (callable instanceof LoaderSingleProvider) {
            return (Provider)callable;
        }
        return new LoaderSingleProvider<T>(callable);
    }
}

