/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.provider;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.provider.Provider;
import net.hasor.cobble.ref.ContextClassLoaderLocal;

public class LoaderSingleProvider<T>
implements Provider<T> {
    private final ContextClassLoaderLocal<T> instance;

    public LoaderSingleProvider(final T instance) {
        this.instance = new ContextClassLoaderLocal<T>(){

            @Override
            protected T initialValue() {
                return instance;
            }
        };
    }

    public LoaderSingleProvider(final Provider<T> provider) {
        this.instance = new ContextClassLoaderLocal<T>(){

            @Override
            protected T initialValue() {
                return provider.get();
            }
        };
    }

    public LoaderSingleProvider(final Supplier<T> supplier) {
        this.instance = new ContextClassLoaderLocal<T>(){

            @Override
            protected T initialValue() {
                return supplier.get();
            }
        };
    }

    public LoaderSingleProvider(final Callable<T> callable) {
        this.instance = new ContextClassLoaderLocal<T>(){

            @Override
            protected T initialValue() {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntime(e);
                }
            }
        };
    }

    @Override
    public T call() throws Exception {
        return this.instance.get();
    }

    public String toString() {
        return "ClassLoaderSingleProvider->" + this.instance.toString();
    }
}

