/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.hasor.cobble.StringUtils;

public class ThreadUtils {
    private static final AtomicInteger globalCnt = new AtomicInteger(0);

    public static ThreadFactory daemonThreadFactory(ClassLoader loader) {
        return ThreadUtils.threadFactory(loader, "Thread-%s", true);
    }

    public static ThreadFactory daemonThreadFactory(ClassLoader loader, String nameTemplate) {
        return ThreadUtils.threadFactory(loader, nameTemplate, true);
    }

    public static ThreadFactory threadFactory(ClassLoader loader, String nameTemplate, boolean isDaemon) {
        String template = StringUtils.isBlank(nameTemplate) ? "Thread-%s" : nameTemplate;
        AtomicInteger cnt = new AtomicInteger(0);
        return run -> {
            Thread t = new Thread(run);
            t.setContextClassLoader(loader);
            t.setName(String.format(template, cnt.incrementAndGet()));
            t.setDaemon(isDaemon);
            return t;
        };
    }

    public static Thread frontThread(ClassLoader loader, Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setContextClassLoader(loader);
        t.setName(String.format("Thread-%s", globalCnt.incrementAndGet()));
        t.setDaemon(false);
        return t;
    }

    public static Thread daemonThread(ClassLoader loader, Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setContextClassLoader(loader);
        t.setName(String.format("Thread-%s", globalCnt.incrementAndGet()));
        t.setDaemon(true);
        return t;
    }
}

