/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.concurrent;

import java.util.concurrent.atomic.AtomicInteger;

public class QoSBucket {
    private static final int DEFAULT_RATE = 50;
    private static final int DEFAULT_PEAK = 100;
    private static final int DEFAULT_WINDOW = 10;
    private final int rate;
    private final int peak;
    private final int timeWindow;
    private final AtomicInteger tokens;
    private volatile long lastRefreshTime;
    private volatile double leftDouble;

    public QoSBucket(int rate) {
        this(rate, 100, 10);
    }

    public QoSBucket() {
        this(50, 100, 10);
    }

    public QoSBucket(int rate, int peak, int timeWindow) {
        this.rate = rate;
        this.peak = peak;
        this.timeWindow = timeWindow;
        double initialToken = (double)(rate * timeWindow) / 1000.0;
        this.tokens = initialToken >= 1.0 ? new AtomicInteger((int)initialToken) : new AtomicInteger(1);
        this.leftDouble = initialToken - Math.floor(initialToken);
        this.lastRefreshTime = System.currentTimeMillis();
    }

    public int getRate() {
        return this.rate;
    }

    public int getPeak() {
        return this.peak;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public boolean check() {
        long now = System.currentTimeMillis();
        if (now > this.lastRefreshTime + (long)this.timeWindow) {
            int currentValue = this.tokens.get();
            double interval = (double)(now - this.lastRefreshTime) / 1000.0;
            double addedDouble = interval * (double)this.rate;
            int added = (int)addedDouble;
            if (added > 0) {
                double addedPlusDouble;
                int addPlus;
                int newValue;
                int n = newValue = (newValue = currentValue + (added += (addPlus = (int)(addedPlusDouble = this.leftDouble + (addedDouble - (double)added))))) > currentValue && newValue < this.peak ? newValue : this.peak;
                if (this.tokens.compareAndSet(currentValue, newValue)) {
                    this.lastRefreshTime = now;
                    this.leftDouble = addedPlusDouble - (double)addPlus;
                }
            }
        }
        int value = this.tokens.get();
        boolean flag = false;
        while (value > 0 && !flag) {
            flag = this.tokens.compareAndSet(value, value - 1);
            value = this.tokens.get();
        }
        return flag;
    }

    public String toString() {
        return "QoSBucket [tokens=" + this.tokens + ", rate=" + this.rate + ", peak=" + this.peak + ", timeWindow=" + this.timeWindow + "]";
    }

    public boolean validate() {
        if (this.rate <= 0 || this.peak <= 0 || this.timeWindow < 1) {
            return false;
        }
        return !((float)this.peak < (float)(this.rate * this.timeWindow) / 1000.0f);
    }
}

