/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.util.Locale;
import net.hasor.cobble.ObjectUtils;

public final class SystemUtils {
    private static final boolean IS_WINDOWS = SystemUtils.isWindows0();
    private static final boolean IS_ANDROID = SystemUtils.isAndroid0();
    private static final boolean IS_OSX = SystemUtils.isOsx0();
    private static final boolean IS_J9_JVM = SystemUtils.isJ9Jvm0();
    private static final boolean IS_IVKVM_DOT_NET = SystemUtils.isIkvmDotNet0();
    private static final boolean IS_SUPER_USER = SystemUtils.maybeSuperUser0();
    private static final int JAVA_VERSION = SystemUtils.javaVersion0();

    public static String getSystemProperty(String key) {
        return SystemUtils.getSystemProperty(key, null);
    }

    public static String getSystemProperty(String key, String defaultValue) {
        ObjectUtils.checkNotNull(key, "key");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = System.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    public static boolean isSupperUser() {
        return IS_SUPER_USER;
    }

    private static boolean isWindows0() {
        return SystemUtils.getSystemProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static boolean isAndroid0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name");
        return "Dalvik".equals(vmName);
    }

    private static boolean isOsx0() {
        String osname = SystemUtils.getSystemProperty("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        return osname.startsWith("macosx") || osname.startsWith("osx");
    }

    private static boolean isJ9Jvm0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name", "").toLowerCase();
        return vmName.startsWith("ibm j9") || vmName.startsWith("eclipse openj9");
    }

    private static boolean isIkvmDotNet0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name", "").toUpperCase(Locale.US);
        return vmName.equals("IKVM.NET");
    }

    private static boolean maybeSuperUser0() {
        String username = SystemUtils.getSystemProperty("user.name");
        if (SystemUtils.isWindows()) {
            return "Administrator".equals(username);
        }
        return "root".equals(username) || "toor".equals(username);
    }

    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        if (SystemUtils.isAndroid0()) {
            return 6;
        }
        String javaSpecVersion = SystemUtils.getSystemProperty("java.specification.version", "1.6");
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            assert (version[1] >= 6);
            return version[1];
        }
        return version[0];
    }
}

