/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.hasor.cobble.function.Property;

class SimpleProperty
implements Property {
    private Field field;
    private Method readerMethod;
    private Method writerMethod;

    SimpleProperty() {
    }

    public void setReader(Method readerMethod) {
        this.readerMethod = readerMethod;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setWriter(Method writerMethod) {
        this.writerMethod = writerMethod;
    }

    public Field getField() {
        return this.field;
    }

    public AccessibleObject getReaderHandler() {
        if (this.readerMethod != null) {
            return this.readerMethod;
        }
        if (this.field != null) {
            return this.field;
        }
        return null;
    }

    public AccessibleObject getWriterHandler() {
        if (this.writerMethod != null) {
            return this.writerMethod;
        }
        if (this.field != null) {
            return this.field;
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return this.writerMethod == null && this.field == null;
    }

    @Override
    public Object get(Object instance) {
        try {
            if (this.readerMethod != null) {
                return this.readerMethod.invoke(instance, new Object[0]);
            }
            if (this.field != null) {
                return this.field.get(instance);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void set(Object instance, Object value) {
        try {
            if (this.writerMethod != null) {
                this.writerMethod.invoke(instance, value);
            } else if (this.field != null) {
                this.field.set(instance, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

