/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import net.hasor.cobble.StringUtils;

public class RandomUtils {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    private static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, values));
        }
    }

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    public static byte[] nextBytes(int count) {
        RandomUtils.isTrue(count >= 0, "Count cannot be negative.", new Object[0]);
        byte[] result = new byte[count];
        RANDOM.nextBytes(result);
        return result;
    }

    public static int nextInt(int startInclusive, int endInclusive) {
        return RandomUtils.nextBigInteger(startInclusive, endInclusive).intValue();
    }

    public static int nextInt() {
        return RandomUtils.nextBigInteger(0, Integer.MAX_VALUE).intValue();
    }

    public static long nextLong(long startInclusive, long endInclusive) {
        return RandomUtils.nextBigInteger(startInclusive, endInclusive).longValue();
    }

    public static long nextLong() {
        return RandomUtils.nextBigInteger(0, Long.MAX_VALUE).longValue();
    }

    public static BigInteger nextBigInteger(Number startInclusive, Number endInclusive) {
        char[] bitChars;
        BigInteger bigRange;
        BigInteger offset;
        int signum;
        BigInteger minBig;
        BigInteger bigInteger = startInclusive instanceof BigInteger ? (BigInteger)startInclusive : (minBig = startInclusive instanceof BigDecimal ? ((BigDecimal)startInclusive).toBigInteger() : BigInteger.valueOf(startInclusive.longValue()));
        BigInteger maxBig = endInclusive instanceof BigInteger ? (BigInteger)endInclusive : (endInclusive instanceof BigDecimal ? ((BigDecimal)endInclusive).toBigInteger() : BigInteger.valueOf(endInclusive.longValue()));
        int n = signum = minBig.signum() == maxBig.signum() ? minBig.signum() : 1;
        if (signum == -1 || minBig.equals(BigInteger.ZERO)) {
            offset = minBig.abs();
            bigRange = minBig.abs().add(maxBig.abs());
        } else {
            offset = minBig.negate();
            bigRange = maxBig.subtract(minBig);
        }
        StringBuilder result = new StringBuilder();
        boolean inFree = false;
        for (char rangeChar : bitChars = bigRange.toString(2).toCharArray()) {
            if (inFree) {
                result.append(RandomUtils.nextBoolean() ? 1 : 0);
                continue;
            }
            boolean oriBit = rangeChar == '1';
            boolean newBit = RandomUtils.nextBoolean();
            boolean bl = inFree = oriBit != newBit && oriBit;
            if (inFree) {
                result.append(0);
                continue;
            }
            result.append(oriBit ? 1 : 0);
        }
        BigInteger after = new BigInteger(result.toString(), 2);
        if (signum == -1) {
            return after.negate().subtract(offset);
        }
        return after.subtract(offset);
    }

    public static double nextDouble(double startInclusive, double endInclusive) {
        RandomUtils.isTrue(endInclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        RandomUtils.isTrue(startInclusive >= 0.0, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextDouble();
    }

    public static double nextDouble() {
        return RandomUtils.nextDouble(0.0, Double.MAX_VALUE);
    }

    public static float nextFloat(float startInclusive, float endInclusive) {
        RandomUtils.isTrue(endInclusive >= startInclusive, "Start value must be smaller or equal to end value.", new Object[0]);
        RandomUtils.isTrue(startInclusive >= 0.0f, "Both range values must be non-negative.", new Object[0]);
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextFloat();
    }

    public static float nextFloat() {
        return RandomUtils.nextFloat(0.0f, Float.MAX_VALUE);
    }

    public static BigDecimal nextDecimal(Number startInclusive, Number endInclusive, Integer scale) {
        BigDecimal result;
        BigDecimal maxBig;
        BigDecimal minBig;
        BigDecimal bigDecimal = startInclusive instanceof BigDecimal ? (BigDecimal)startInclusive : (minBig = startInclusive instanceof BigInteger ? new BigDecimal((BigInteger)startInclusive) : BigDecimal.valueOf(startInclusive.doubleValue()));
        BigDecimal bigDecimal2 = endInclusive instanceof BigDecimal ? (BigDecimal)endInclusive : (maxBig = endInclusive instanceof BigInteger ? new BigDecimal((BigInteger)endInclusive) : BigDecimal.valueOf(endInclusive.doubleValue()));
        if (scale == null) {
            BigDecimal[] minParts = minBig.divideAndRemainder(BigDecimal.ONE);
            BigDecimal[] maxParts = maxBig.divideAndRemainder(BigDecimal.ONE);
            scale = Math.max(minParts[1].scale(), maxParts[1].scale());
        }
        if (scale == 0) {
            result = new BigDecimal(RandomUtils.nextBigInteger(minBig, maxBig));
        } else {
            BigDecimal scaleMul = new BigDecimal("1" + StringUtils.repeat("0", (int)scale));
            BigDecimal scaleMin = minBig.multiply(scaleMul);
            BigDecimal scaleMax = maxBig.multiply(scaleMul);
            result = new BigDecimal(RandomUtils.nextBigInteger(scaleMin, scaleMax)).divide(scaleMul);
        }
        return result.setScale((int)scale, 1);
    }

    public static BigDecimal nextDecimal(Integer precision, Integer scale) {
        if (precision == null && scale == null) {
            return BigDecimal.valueOf(RandomUtils.nextDouble());
        }
        if (precision == null) {
            precision = scale;
        }
        if (scale == null) {
            scale = 0;
        }
        BigDecimal randomDecimal = new BigDecimal(RandomUtils.nextBigInteger(0, new BigInteger(StringUtils.repeat("9", (int)precision))));
        BigDecimal divNum = new BigDecimal("1" + StringUtils.repeat("0", (int)scale));
        randomDecimal = randomDecimal.divide(divNum, (int)scale, 1).stripTrailingZeros();
        return RandomUtils.nextBoolean() ? randomDecimal : randomDecimal.negate();
    }
}

