/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import net.hasor.cobble.StringUtils;

public final class NumberUtils {
    private static final int BOOL = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int CHAR = 4;
    private static final int INT = 5;
    private static final int LONG = 6;
    private static final int FLOAT = 7;
    private static final int DOUBLE = 8;
    private static final int BIGINT = 9;
    private static final int BIGDEC = 10;
    private static final int NONE = 0;

    public static int stringToInt(String str) {
        return NumberUtils.stringToInt(str, 0);
    }

    public static int stringToInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Number createNumber(String val) throws NumberFormatException {
        String mant;
        String dec;
        if (val == null) {
            return null;
        }
        if (val.length() == 0) {
            throw new NumberFormatException("\"\" is not a valid number.");
        }
        if (val.length() == 1 && !Character.isDigit(val.charAt(0))) {
            throw new NumberFormatException(val + " is not a valid number.");
        }
        if (val.startsWith("--")) {
            return null;
        }
        if (val.startsWith("0x") || val.startsWith("-0x")) {
            return NumberUtils.createInteger(val);
        }
        char lastChar = val.charAt(val.length() - 1);
        int decPos = val.indexOf(46);
        int expPos = val.indexOf(101) + val.indexOf(69) + 1;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos) {
                    throw new NumberFormatException(val + " is not a valid number.");
                }
                dec = val.substring(decPos + 1, expPos);
            } else {
                dec = val.substring(decPos + 1);
            }
            mant = val.substring(0, decPos);
        } else {
            mant = expPos > -1 ? val.substring(0, expPos) : val;
            dec = null;
        }
        if (!Character.isDigit(lastChar)) {
            String exp = expPos > -1 && expPos < val.length() - 1 ? val.substring(expPos + 1, val.length() - 1) : null;
            String numeric2 = val.substring(0, val.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (numeric2.charAt(0) == '-' && NumberUtils.isDigits(numeric2.substring(1)) || NumberUtils.isDigits(numeric2))) {
                        try {
                            return NumberUtils.createLong(numeric2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return NumberUtils.createBigInteger(numeric2);
                        }
                    }
                    throw new NumberFormatException(val + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(numeric2);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException f) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(numeric2);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(val + " is not a valid number.");
        }
        String exp = expPos > -1 && expPos < val.length() - 1 ? val.substring(expPos + 1) : null;
        if (dec == null && exp == null) {
            try {
                return NumberUtils.createInteger(val);
            }
            catch (NumberFormatException numeric2) {
                try {
                    return NumberUtils.createLong(val);
                }
                catch (NumberFormatException numeric2) {
                    return NumberUtils.createBigInteger(val);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp);
        try {
            Float f = NumberUtils.createFloat(val);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException f) {
            // empty catch block
        }
        try {
            Double d = NumberUtils.createDouble(val);
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(val);
    }

    private static boolean isAllZeros(String s) {
        if (s == null) {
            return true;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') continue;
            return false;
        }
        return s.length() > 0;
    }

    public static Float createFloat(String val) {
        return Float.valueOf(val);
    }

    public static Double createDouble(String val) {
        return Double.valueOf(val);
    }

    public static Integer createInteger(String val) {
        return Integer.decode(val);
    }

    public static Long createLong(String val) {
        return Long.valueOf(val);
    }

    public static BigInteger createUnsignedLong(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        long lowValue = value & Long.MAX_VALUE;
        return BigInteger.valueOf(lowValue).add(BigInteger.valueOf(Long.MAX_VALUE)).add(BigInteger.ONE);
    }

    public static BigInteger createBigInteger(String val) {
        return new BigInteger(val);
    }

    public static BigDecimal createBigDecimal(String val) {
        return new BigDecimal(val);
    }

    public static long minimum(long a, long b, long c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int minimum(int a, int b, int c) {
        if (b < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static long maximum(long a, long b, long c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int maximum(int a, int b, int c) {
        if (b > a) {
            a = b;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int compare(double lhs, double rhs) {
        long rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        long lhsBits = Double.doubleToLongBits(lhs);
        if (lhsBits == (rhsBits = Double.doubleToLongBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static int compare(float lhs, float rhs) {
        int rhsBits;
        if (lhs < rhs) {
            return -1;
        }
        if (lhs > rhs) {
            return 1;
        }
        int lhsBits = Float.floatToIntBits(lhs);
        if (lhsBits == (rhsBits = Float.floatToIntBits(rhs))) {
            return 0;
        }
        if (lhsBits < rhsBits) {
            return -1;
        }
        return 1;
    }

    public static boolean isDigits(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isByteType(Class<?> targetType) {
        return targetType.equals(Byte.class) || targetType.equals(Byte.TYPE);
    }

    public static boolean isShortType(Class<?> targetType) {
        return targetType.equals(Short.class) || targetType.equals(Short.TYPE);
    }

    public static boolean isIntType(Class<?> targetType) {
        return targetType.equals(Integer.class) || targetType.equals(Integer.TYPE);
    }

    public static boolean isLongType(Class<?> targetType) {
        return targetType.equals(Long.class) || targetType.equals(Long.TYPE);
    }

    public static boolean isFloatType(Class<?> targetType) {
        return targetType.equals(Float.class) || targetType.equals(Float.TYPE);
    }

    public static boolean isDoubleType(Class<?> targetType) {
        return targetType.equals(Double.class) || targetType.equals(Double.TYPE);
    }

    public static boolean isNumber(Object object) {
        return object instanceof Number;
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isByteNumber(Object number) {
        return number instanceof Byte;
    }

    public static boolean isShortNumber(Object number) {
        return number instanceof Short;
    }

    public static boolean isIntegerNumber(Object number) {
        return number instanceof Integer;
    }

    public static boolean isCharacter(Object number) {
        return number instanceof Character;
    }

    public static boolean isLongNumber(Object number) {
        return number instanceof Long;
    }

    public static boolean isFloatNumber(Object number) {
        return number instanceof Float;
    }

    public static boolean isDoubleNumber(Object number) {
        return number instanceof Double;
    }

    private static int getNumericType(Number v1, Number v2) {
        int v2Type;
        int v1Type = NumberUtils.getNumericType(v1);
        if (v1Type == (v2Type = NumberUtils.getNumericType(v2))) {
            return v1Type;
        }
        if (v1Type == 0 || v2Type == 0) {
            return 0;
        }
        if (v1Type <= 6 && v2Type <= 6) {
            return v1Type == 6 || v2Type == 6 ? 6 : 5;
        }
        if (v1Type <= 8 && v2Type <= 8) {
            boolean useFloat = v1Type <= 3 || v2Type <= 3 && (v1Type == 7 || v2Type == 7);
            return useFloat ? 7 : 8;
        }
        boolean useDec = v1Type == 7 || v1Type == 8 || v2Type == 7 || v2Type == 8;
        return useDec ? 10 : 9;
    }

    public static int getNumericType(Object value) {
        if (NumberUtils.isBoolean(value)) {
            return 1;
        }
        if (NumberUtils.isByteNumber(value)) {
            return 2;
        }
        if (NumberUtils.isShortNumber(value)) {
            return 3;
        }
        if (NumberUtils.isCharacter(value)) {
            return 4;
        }
        if (NumberUtils.isIntegerNumber(value)) {
            return 5;
        }
        if (NumberUtils.isLongNumber(value)) {
            return 6;
        }
        if (value instanceof BigInteger) {
            return 9;
        }
        if (NumberUtils.isFloatNumber(value)) {
            return 7;
        }
        if (NumberUtils.isDoubleNumber(value)) {
            return 8;
        }
        if (value instanceof BigDecimal) {
            return 10;
        }
        return 0;
    }

    private static int intValue(Object value) {
        if (value == null) {
            return 0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).intValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        return Integer.parseInt(value.toString().trim());
    }

    private static long longValue(Object value) {
        if (value == null) {
            return 0L;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).longValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        return Long.parseLong(value.toString().trim());
    }

    private static BigInteger bigIntValue(Object value) {
        if (value == null) {
            return BigInteger.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigInteger.class) {
            return (BigInteger)value;
        }
        if (c == BigDecimal.class) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (c.getSuperclass() == Number.class) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (c == Boolean.class) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigInteger.valueOf(((Character)value).charValue());
        }
        return new BigInteger(value.toString().trim());
    }

    private static float floatValue(Object value) {
        if (value == null) {
            return 0.0f;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).floatValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0f : 0.0f;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        String s = value.toString().trim();
        return s.length() == 0 ? 0.0f : Float.parseFloat(s);
    }

    private static double doubleValue(Object value) {
        if (value == null) {
            return 0.0;
        }
        Class<?> c = value.getClass();
        if (c.getSuperclass() == Number.class) {
            return ((Number)value).doubleValue();
        }
        if (c == Boolean.class) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (c == Character.class) {
            return ((Character)value).charValue();
        }
        String s = value.toString().trim();
        return s.length() == 0 ? 0.0 : Double.parseDouble(s);
    }

    private static BigDecimal bigDecimalValue(Object value) {
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        Class<?> c = value.getClass();
        if (c == BigDecimal.class) {
            return (BigDecimal)value;
        }
        if (c == BigInteger.class) {
            return new BigDecimal((BigInteger)value);
        }
        if (c.getSuperclass() == Number.class) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (c == Boolean.class) {
            return BigDecimal.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (c == Character.class) {
            return BigDecimal.valueOf(((Character)value).charValue());
        }
        return new BigDecimal(value.toString().trim());
    }

    public static Number add(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            return NumberUtils.decimalAdd(obj1, obj2);
        }
        return NumberUtils.integerAdd(obj1, obj2);
    }

    public static Number subtract(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            return NumberUtils.decimalSubtract(obj1, obj2);
        }
        return NumberUtils.integerSubtract(obj1, obj2);
    }

    public static Number multiply(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            return NumberUtils.decimalMultiply(obj1, obj2);
        }
        return NumberUtils.integerMultiply(obj1, obj2);
    }

    public static Number divide(Number obj1, Number obj2, int precision, RoundingMode roundingEnum) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            if (roundingEnum == null) {
                roundingEnum = RoundingMode.HALF_UP;
            }
            if (precision <= 0) {
                precision = 23;
            }
            return NumberUtils.decimalDivide(obj1, obj2, precision, roundingEnum);
        }
        return NumberUtils.integerDivide(obj1, obj2);
    }

    public static Number aliquot(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            return NumberUtils.decimalAliquot(obj1, obj2);
        }
        return NumberUtils.integerDivide(obj1, obj2);
    }

    public static Number mod(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            return NumberUtils.decimalMod(obj1, obj2);
        }
        return NumberUtils.integerMod(obj1, obj2);
    }

    public static Number negate(Number obj) {
        if (NumberUtils.isDecimal(obj)) {
            return NumberUtils.decimalNegate(obj);
        }
        return NumberUtils.integerNegate(obj);
    }

    public static boolean isDecimal(Number tester) {
        if (tester instanceof BigDecimal) {
            return true;
        }
        if (NumberUtils.isFloatNumber(tester)) {
            return true;
        }
        return NumberUtils.isDoubleNumber(tester);
    }

    private static Number newReal(int realType, long value) {
        switch (realType) {
            case 1: {
                return value == 0L ? 0 : 1;
            }
            case 2: {
                return (byte)value;
            }
            case 3: {
                return (short)value;
            }
            case 4: 
            case 5: {
                return (int)value;
            }
        }
        return value;
    }

    private static Number newReal(int realType, BigInteger value) {
        switch (realType) {
            case 1: {
                return BigInteger.ZERO.compareTo(value) == 0 ? 0 : 1;
            }
            case 2: {
                return value.byteValue();
            }
            case 3: {
                return value.shortValue();
            }
            case 4: 
            case 5: {
                return value.intValue();
            }
            case 6: {
                return value.longValue();
            }
        }
        return value;
    }

    private static Number newReal(int realType, double value) {
        if (realType == 7) {
            return Float.valueOf((float)value);
        }
        return value;
    }

    private static Number newReal(int realType, BigDecimal value) {
        if (realType == 7) {
            return Float.valueOf(value.floatValue());
        }
        if (realType == 8) {
            return value.doubleValue();
        }
        return value;
    }

    private static Number integerAdd(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, NumberUtils.intValue(obj1) + NumberUtils.intValue(obj2));
            }
            case 6: {
                return NumberUtils.newReal(maxType, NumberUtils.longValue(obj1) + NumberUtils.longValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj1).add(NumberUtils.bigIntValue(obj2)));
    }

    private static Number integerSubtract(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, NumberUtils.intValue(obj1) - NumberUtils.intValue(obj2));
            }
            case 6: {
                return NumberUtils.newReal(maxType, NumberUtils.longValue(obj1) - NumberUtils.longValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj1).subtract(NumberUtils.bigIntValue(obj2)));
    }

    private static Number integerMultiply(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, NumberUtils.intValue(obj1) * NumberUtils.intValue(obj2));
            }
            case 6: {
                return NumberUtils.newReal(maxType, NumberUtils.longValue(obj1) * NumberUtils.longValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj1).multiply(NumberUtils.bigIntValue(obj2)));
    }

    private static Number integerDivide(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, NumberUtils.intValue(obj1) / NumberUtils.intValue(obj2));
            }
            case 6: {
                return NumberUtils.newReal(maxType, NumberUtils.longValue(obj1) / NumberUtils.longValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj1).divide(NumberUtils.bigIntValue(obj2)));
    }

    private static Number integerMod(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, NumberUtils.intValue(obj1) % NumberUtils.intValue(obj2));
            }
            case 6: {
                return NumberUtils.newReal(maxType, NumberUtils.longValue(obj1) % NumberUtils.longValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj1).mod(NumberUtils.bigIntValue(obj2)));
    }

    private static Number integerNegate(Number obj) {
        int maxType = NumberUtils.getNumericType(obj);
        switch (maxType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return NumberUtils.newReal(maxType, -NumberUtils.intValue(obj));
            }
            case 6: {
                return NumberUtils.newReal(maxType, -NumberUtils.longValue(obj));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigIntValue(obj).negate());
    }

    private static Number decimalAdd(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, NumberUtils.floatValue(obj1) + NumberUtils.floatValue(obj2));
            }
            case 8: {
                return NumberUtils.newReal(maxType, NumberUtils.doubleValue(obj1) + NumberUtils.doubleValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).add(NumberUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalSubtract(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, NumberUtils.floatValue(obj1) - NumberUtils.floatValue(obj2));
            }
            case 8: {
                return NumberUtils.newReal(maxType, NumberUtils.doubleValue(obj1) - NumberUtils.doubleValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).subtract(NumberUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalMultiply(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, NumberUtils.floatValue(obj1) * NumberUtils.floatValue(obj2));
            }
            case 8: {
                return NumberUtils.newReal(maxType, NumberUtils.doubleValue(obj1) * NumberUtils.doubleValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).multiply(NumberUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalDivide(Number obj1, Number obj2, int precision, RoundingMode roundingEnum) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, NumberUtils.floatValue(obj1) / NumberUtils.floatValue(obj2));
            }
            case 8: {
                return NumberUtils.newReal(maxType, NumberUtils.doubleValue(obj1) / NumberUtils.doubleValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).divide(NumberUtils.bigDecimalValue(obj2), precision, roundingEnum));
    }

    private static Number decimalAliquot(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, (int)(NumberUtils.floatValue(obj1) / NumberUtils.floatValue(obj2)));
            }
            case 8: {
                return NumberUtils.newReal(maxType, (long)(NumberUtils.doubleValue(obj1) / NumberUtils.doubleValue(obj2)));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).divideToIntegralValue(NumberUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalMod(Number obj1, Number obj2) {
        int maxType = NumberUtils.getNumericType(obj1, obj2);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, NumberUtils.floatValue(obj1) % NumberUtils.floatValue(obj2));
            }
            case 8: {
                return NumberUtils.newReal(maxType, NumberUtils.doubleValue(obj1) % NumberUtils.doubleValue(obj2));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj1).remainder(NumberUtils.bigDecimalValue(obj2)));
    }

    private static Number decimalNegate(Number obj) {
        int maxType = NumberUtils.getNumericType(obj);
        switch (maxType) {
            case 7: {
                return NumberUtils.newReal(maxType, -NumberUtils.floatValue(obj));
            }
            case 8: {
                return NumberUtils.newReal(maxType, -NumberUtils.doubleValue(obj));
            }
        }
        return NumberUtils.newReal(maxType, NumberUtils.bigDecimalValue(obj).negate());
    }

    private static int getNumericTypeWithCompare(Number v1, Number v2) {
        int numericType = NumberUtils.getNumericType(v1, v2);
        if (numericType == 0) {
            numericType = NumberUtils.isDecimal(v1) || NumberUtils.isDecimal(v2) ? 10 : 9;
        }
        return numericType;
    }

    public static boolean eq(Number obj1, Number obj2) {
        int numericType = NumberUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) == NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) == NumberUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return NumberUtils.doubleValue(obj1) == NumberUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return NumberUtils.bigIntValue(obj1).compareTo(NumberUtils.bigIntValue(obj2)) == 0;
        }
        if (numericType == 10) {
            return NumberUtils.bigDecimalValue(obj1).compareTo(NumberUtils.bigDecimalValue(obj2)) == 0;
        }
        return obj1.doubleValue() == obj2.doubleValue();
    }

    public static boolean gt(Number obj1, Number obj2) {
        int numericType = NumberUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) > NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) > NumberUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return NumberUtils.doubleValue(obj1) > NumberUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return NumberUtils.bigIntValue(obj1).compareTo(NumberUtils.bigIntValue(obj2)) > 0;
        }
        if (numericType == 10) {
            return NumberUtils.bigDecimalValue(obj1).compareTo(NumberUtils.bigDecimalValue(obj2)) > 0;
        }
        return obj1.doubleValue() > obj2.doubleValue();
    }

    public static boolean gteq(Number obj1, Number obj2) {
        int numericType = NumberUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) >= NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) >= NumberUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return NumberUtils.doubleValue(obj1) >= NumberUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return NumberUtils.bigIntValue(obj1).compareTo(NumberUtils.bigIntValue(obj2)) >= 0;
        }
        if (numericType == 10) {
            return NumberUtils.bigDecimalValue(obj1).compareTo(NumberUtils.bigDecimalValue(obj2)) >= 0;
        }
        return obj1.doubleValue() >= obj2.doubleValue();
    }

    public static boolean lt(Number obj1, Number obj2) {
        int numericType = NumberUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) < NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) < NumberUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return NumberUtils.doubleValue(obj1) < NumberUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return NumberUtils.bigIntValue(obj1).compareTo(NumberUtils.bigIntValue(obj2)) < 0;
        }
        if (numericType == 10) {
            return NumberUtils.bigDecimalValue(obj1).compareTo(NumberUtils.bigDecimalValue(obj2)) < 0;
        }
        return obj1.doubleValue() < obj2.doubleValue();
    }

    public static boolean lteq(Number obj1, Number obj2) {
        int numericType = NumberUtils.getNumericTypeWithCompare(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) <= NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) <= NumberUtils.longValue(obj2);
        }
        if (numericType <= 8) {
            return NumberUtils.doubleValue(obj1) <= NumberUtils.doubleValue(obj2);
        }
        if (numericType == 9) {
            return NumberUtils.bigIntValue(obj1).compareTo(NumberUtils.bigIntValue(obj2)) <= 0;
        }
        if (numericType == 10) {
            return NumberUtils.bigDecimalValue(obj1).compareTo(NumberUtils.bigDecimalValue(obj2)) <= 0;
        }
        return obj1.doubleValue() <= obj2.doubleValue();
    }

    private static void checkDecimal(Number obj1, Number obj2) {
        if (NumberUtils.isDecimal(obj1) || NumberUtils.isDecimal(obj2)) {
            throw new NumberFormatException("value mast not be Decimal.");
        }
    }

    public static Number and(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) & NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) & NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).and(NumberUtils.bigIntValue(obj2));
    }

    public static Number or(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) | NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) | NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).or(NumberUtils.bigIntValue(obj2));
    }

    public static Number xor(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) ^ NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) ^ NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).xor(NumberUtils.bigIntValue(obj2));
    }

    public static Number shiftLeft(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) << NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) << (int)NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).shiftLeft(NumberUtils.intValue(obj2));
    }

    public static Number shiftRight(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) >> NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) >> (int)NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).shiftRight(NumberUtils.intValue(obj2));
    }

    public static Number shiftRightWithUnsigned(Number obj1, Number obj2) {
        NumberUtils.checkDecimal(obj1, obj2);
        int numericType = NumberUtils.getNumericType(obj1, obj2);
        if (numericType <= 5) {
            return NumberUtils.intValue(obj1) >>> NumberUtils.intValue(obj2);
        }
        if (numericType <= 6) {
            return NumberUtils.longValue(obj1) >>> (int)NumberUtils.longValue(obj2);
        }
        return NumberUtils.bigIntValue(obj1).shiftRight(NumberUtils.intValue(obj2));
    }

    public static BigDecimal round(double v, int scale) {
        return NumberUtils.round(v, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale) {
        return NumberUtils.round(v, scale).toString();
    }

    public static BigDecimal round(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale) {
        return NumberUtils.round(number, scale, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale) {
        return NumberUtils.round(numberStr, scale).toString();
    }

    public static BigDecimal round(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(Double.toString(v), scale, roundingMode);
    }

    public static String roundStr(double v, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(v, scale, roundingMode).toString();
    }

    public static BigDecimal round(String numberStr, int scale, RoundingMode roundingMode) {
        if (StringUtils.isBlank(numberStr)) {
            throw new IllegalArgumentException("this String argument must have text; it must not be null, empty, or blank");
        }
        if (scale < 0) {
            scale = 0;
        }
        return NumberUtils.round(NumberUtils.createBigDecimal(numberStr), scale, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale < 0) {
            scale = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale, roundingMode);
    }

    public static String roundStr(String numberStr, int scale, RoundingMode roundingMode) {
        return NumberUtils.round(numberStr, scale, roundingMode).toString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale) {
        if (number instanceof BigDecimal) {
            return NumberUtils.roundHalfEven(number, scale);
        }
        if (number instanceof BigInteger) {
            return NumberUtils.roundHalfEven(new BigDecimal((BigInteger)number), scale);
        }
        return NumberUtils.roundHalfEven(NumberUtils.createBigDecimal(number.toString()), scale);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale) {
        if (number instanceof BigDecimal) {
            return NumberUtils.roundHalfEven(number, scale);
        }
        if (number instanceof BigInteger) {
            return NumberUtils.roundHalfEven(new BigDecimal((BigInteger)number), scale);
        }
        return NumberUtils.roundHalfEven(NumberUtils.createBigDecimal(number.toString()), scale);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale) {
        return NumberUtils.round(value, scale, RoundingMode.DOWN);
    }
}

