/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.supplier;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.supplier.ClassLoaderSingleProvider;
import net.hasor.cobble.supplier.SingleProvider;
import net.hasor.cobble.supplier.ThreadSingleProvider;

@FunctionalInterface
public interface Provider<T>
extends Supplier<T>,
Callable<T> {
    @Override
    default public T get() {
        try {
            return this.call();
        }
        catch (Exception e) {
            throw ExceptionUtils.toRuntime(e);
        }
    }

    @Override
    public T call() throws Exception;

    default public Provider<T> asSingle() {
        return Provider.of(new SingleProvider(this));
    }

    default public Provider<T> asThread() {
        return Provider.of(new ThreadSingleProvider(this));
    }

    default public Provider<T> asLoader() {
        return Provider.of(new ClassLoaderSingleProvider(this));
    }

    public static <T> Provider<T> of(T instance) {
        return () -> instance;
    }

    public static <T> Provider<T> of(Supplier<T> supplier) {
        return supplier::get;
    }

    public static <T> Provider<T> of(Callable<T> callable) {
        return callable::call;
    }

    public static <V, T extends V> Provider<V> of2(T instance) {
        return () -> instance;
    }

    public static <V, T extends V> Provider<V> of2(Supplier<T> supplier) {
        return supplier::get;
    }

    public static <V, T extends V> Provider<V> of2(Callable<T> callable) {
        return callable::call;
    }
}

