/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.scope;

import java.util.function.Supplier;

@FunctionalInterface
public interface Scope {
    public <T> Supplier<T> scope(Object var1, Supplier<T> var2);

    default public <T> Supplier<T> chainScope(Object key, Scope secondScope, Supplier<T> provider) {
        Scope[] scopeArray = new Scope[]{secondScope};
        return this.chainScope(key, scopeArray, 0, scopeArray.length, provider);
    }

    default public <T> Supplier<T> chainScope(Object key, Scope[] scopeChain, Supplier<T> provider) {
        return this.chainScope(key, scopeChain, 0, scopeChain.length, provider);
    }

    default public <T> Supplier<T> chainScope(Object key, Scope[] scopeChain, int start, int end, Supplier<T> provider) {
        Supplier<Object> nextSupplier = provider;
        if (start < end) {
            for (int i = start; i < end; ++i) {
                Scope currentScope = scopeChain[end - i - 1];
                Supplier finalNextSupplier = nextSupplier;
                nextSupplier = () -> currentScope.scope(key, finalNextSupplier).get();
            }
        }
        Supplier finalSupplier = nextSupplier;
        return () -> {
            Object target;
            Supplier scope = this.scope(key, finalSupplier);
            if (scope != null && (target = scope.get()) != null) {
                return target;
            }
            return finalSupplier.get();
        };
    }
}

