/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble.logging;

import java.lang.reflect.Constructor;
import net.hasor.cobble.logging.LogException;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.jdk14.Jdk14LoggingImpl;
import net.hasor.cobble.logging.log4j.Logger4JImpl;
import net.hasor.cobble.logging.log4j2.Logger4J2Impl;
import net.hasor.cobble.logging.nologging.NoLoggingImpl;
import net.hasor.cobble.logging.slf4j.Slf4jImpl;
import net.hasor.cobble.logging.stdout.StdOutImpl;

public final class LoggerFactory {
    public static final String MARKER = "COBBLE";
    private static Constructor<? extends Logger> logConstructor;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogger(Class<? extends Logger> clazz) {
        LoggerFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogger() {
        LoggerFactory.setImplementation(Slf4jImpl.class);
    }

    public static synchronized void useLog4JLogger() {
        LoggerFactory.setImplementation(Logger4JImpl.class);
    }

    public static synchronized void useLog4J2Logger() {
        LoggerFactory.setImplementation(Logger4J2Impl.class);
    }

    public static synchronized void useJdkLogger() {
        LoggerFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static synchronized void useStdOutLogger() {
        LoggerFactory.setImplementation(StdOutImpl.class);
    }

    public static synchronized void useNoLogger() {
        LoggerFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Logger> implClass) {
        try {
            Constructor<? extends Logger> candidate = implClass.getConstructor(String.class);
            Logger logger = candidate.newInstance(LoggerFactory.class.getName());
            if (logger.isDebugEnabled()) {
                logger.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LoggerFactory.tryImplementation(LoggerFactory::useSlf4jLogger);
        LoggerFactory.tryImplementation(LoggerFactory::useLog4J2Logger);
        LoggerFactory.tryImplementation(LoggerFactory::useLog4JLogger);
        LoggerFactory.tryImplementation(LoggerFactory::useJdkLogger);
        LoggerFactory.tryImplementation(LoggerFactory::useNoLogger);
    }
}

