/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.security.AccessController;
import java.util.Locale;
import net.hasor.cobble.ObjectUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;

public final class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);
    private static final boolean IS_WINDOWS = SystemUtils.isWindows0();
    private static final boolean IS_ANDROID = SystemUtils.isAndroid0();
    private static final boolean IS_OSX = SystemUtils.isOsx0();
    private static final boolean IS_J9_JVM = SystemUtils.isJ9Jvm0();
    private static final boolean IS_IVKVM_DOT_NET = SystemUtils.isIkvmDotNet0();
    private static final boolean IS_SUPER_USER = SystemUtils.maybeSuperUser0();

    public static String getSystemProperty(String key) {
        return SystemUtils.getSystemProperty(key, null);
    }

    public static String getSystemProperty(String key, String defaultValue) {
        ObjectUtils.checkNotNull(key, "key");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(() -> System.getProperty(key));
        }
        catch (SecurityException e) {
            logger.error("Unable to retrieve a system property '" + key + "'; default values will be used.", e);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    public static boolean isSupperUser() {
        return IS_SUPER_USER;
    }

    private static boolean isWindows0() {
        boolean windows = SystemUtils.getSystemProperty("os.name", "").toLowerCase(Locale.US).contains("win");
        if (windows) {
            logger.debug("Platform: Windows");
        }
        return windows;
    }

    private static boolean isAndroid0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (isAndroid) {
            logger.debug("Platform: Android");
        }
        return isAndroid;
    }

    private static boolean isOsx0() {
        boolean osx;
        String osname = SystemUtils.getSystemProperty("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        boolean bl = osx = osname.startsWith("macosx") || osname.startsWith("osx");
        if (osx) {
            logger.debug("Platform: MacOS");
        }
        return osx;
    }

    private static boolean isJ9Jvm0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name", "").toLowerCase();
        return vmName.startsWith("ibm j9") || vmName.startsWith("eclipse openj9");
    }

    private static boolean isIkvmDotNet0() {
        String vmName = SystemUtils.getSystemProperty("java.vm.name", "").toUpperCase(Locale.US);
        return vmName.equals("IKVM.NET");
    }

    private static boolean maybeSuperUser0() {
        String username = SystemUtils.getSystemProperty("user.name");
        if (SystemUtils.isWindows()) {
            return "Administrator".equals(username);
        }
        return "root".equals(username) || "toor".equals(username);
    }
}

