/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.cobble;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.hasor.cobble.SimpleProperty;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterUtils;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.reflect.MethodUtils;
import net.hasor.cobble.reflect.SFunction;

public class BeanUtils {
    private static final Annotation[] ANNOTATION_EMPTY = new Annotation[0];

    public static Object getDefaultValue(Class<?> returnType) {
        if (returnType == null || !returnType.isPrimitive()) {
            return null;
        }
        if (returnType == Integer.TYPE) {
            return 0;
        }
        if (returnType == Byte.TYPE) {
            return (byte)0;
        }
        if (returnType == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (returnType == Double.TYPE) {
            return 0.0;
        }
        if (returnType == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (returnType == Long.TYPE) {
            return 0L;
        }
        if (returnType == Short.TYPE) {
            return (short)0;
        }
        if (returnType == Boolean.TYPE) {
            return false;
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        if (returnType.isArray()) {
            return null;
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?>[] paramArray) {
        if (paramArray == null) {
            return null;
        }
        Object[] objs = new Object[paramArray.length];
        for (int i = 0; i < paramArray.length; ++i) {
            objs[i] = BeanUtils.getDefaultValue(paramArray[i]);
        }
        return objs;
    }

    public static List<Field> getFields(Class<?> type) {
        return Arrays.asList(type.getFields());
    }

    public static Map<String, Field> getFieldMap(Class<?> target, String field) {
        if (field == null || target == null) {
            return null;
        }
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field f : target.getFields()) {
            result.put(f.getName(), f);
        }
        return result;
    }

    public static List<Method> getMethods(Class<?> type) {
        return Arrays.asList(type.getMethods());
    }

    public static Field getField(Class<?> target, String field) {
        if (field == null || target == null) {
            return null;
        }
        for (Field f : target.getFields()) {
            if (!f.getName().equals(field)) continue;
            return f;
        }
        return null;
    }

    public static Method getMethod(Class<?> target, String name, Class<?>[] paramType) {
        try {
            return target.getMethod(name, paramType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeMethod(Object target, String name, Object ... objects) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] ms;
        if (target == null) {
            return null;
        }
        Class<?> targetType = target.getClass();
        Method invokeMethod = null;
        for (Method m : ms = targetType.getMethods()) {
            Class<?>[] paramTypes;
            if (!m.getName().equals(name) || (paramTypes = m.getParameterTypes()).length != objects.length) continue;
            boolean isFind = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                Object param_object = objects[i];
                if (param_object == null || paramTypes[i].isAssignableFrom(param_object.getClass())) continue;
                isFind = false;
                break;
            }
            if (!isFind) continue;
            invokeMethod = m;
        }
        if (invokeMethod == null) {
            throw new NullPointerException(name + " invokeMethod is null.");
        }
        return invokeMethod.invoke(target, objects);
    }

    public static Map<String, Field> getALLFields(Class<?> target) {
        if (target == null) {
            return null;
        }
        LinkedHashMap<String, Field> fMap = new LinkedHashMap<String, Field>();
        BeanUtils.findALLFields(target, fMap);
        return fMap;
    }

    private static void findALLFields(Class<?> target, Map<String, Field> fMap) {
        if (target == null) {
            return;
        }
        for (Field f : target.getDeclaredFields()) {
            if (fMap.containsKey(f.getName())) continue;
            fMap.put(f.getName(), f);
        }
        for (Field f : target.getFields()) {
            if (fMap.containsKey(f.getName())) continue;
            fMap.put(f.getName(), f);
        }
        Class<?> superType = target.getSuperclass();
        if (superType == null || superType == target) {
            return;
        }
        BeanUtils.findALLFields(superType, fMap);
    }

    public static List<Method> findALLMethods(Class<?> target) {
        if (target == null) {
            return null;
        }
        ArrayList<Method> mList = new ArrayList<Method>();
        BeanUtils.findALLMethods(target, mList);
        return mList;
    }

    private static void findALLMethods(Class<?> target, ArrayList<Method> mList) {
        if (target == null) {
            return;
        }
        for (Method method : target.getDeclaredMethods()) {
            if (mList.contains(method)) continue;
            mList.add(method);
        }
        for (Method method : target.getMethods()) {
            if (mList.contains(method)) continue;
            mList.add(method);
        }
        Class<?> superType = target.getSuperclass();
        if (superType == null || superType == target) {
            return;
        }
        BeanUtils.findALLMethods(superType, mList);
    }

    public static List<String> getProperties(Class<?> target) {
        ArrayList<String> mnames = new ArrayList<String>();
        List<Method> ms = BeanUtils.getMethods(target);
        for (Method m : ms) {
            if (m.getDeclaringClass() == Object.class) continue;
            String name = m.getName();
            if (name.startsWith("get") || name.startsWith("set")) {
                name = name.substring(3);
            } else {
                if (!name.startsWith("is")) continue;
                name = name.substring(2);
            }
            if (name.equals("") || mnames.contains(name = StringUtils.firstCharToLowerCase(name))) continue;
            mnames.add(name);
        }
        return mnames;
    }

    public static Annotation[] getPropertyAnnotation(Class<?> target, String property) {
        Map<String, Property> propertyMap = BeanUtils.getPropertyFunc(target, (Method test) -> test.getName().equals(property));
        if (!propertyMap.containsKey(property)) {
            return ANNOTATION_EMPTY;
        }
        return BeanUtils.getPropertyAnnotation(propertyMap.get(property));
    }

    public static Annotation[] getPropertyAnnotation(Property property) {
        if (!(property instanceof SimpleProperty)) {
            return ANNOTATION_EMPTY;
        }
        SimpleProperty propertyFunc = (SimpleProperty)property;
        Field propertyField = propertyFunc.getField();
        AccessibleObject readerHandler = propertyFunc.getReaderHandler();
        AccessibleObject writerHandler = propertyFunc.getWriterHandler();
        Annotation[] arrays1 = readerHandler == null ? ANNOTATION_EMPTY : propertyField.getAnnotations();
        Annotation[] arrays2 = readerHandler == null ? ANNOTATION_EMPTY : readerHandler.getAnnotations();
        Annotation[] arrays3 = writerHandler == null ? ANNOTATION_EMPTY : writerHandler.getAnnotations();
        Annotation[] result = new Annotation[arrays1.length + arrays2.length + arrays3.length];
        System.arraycopy(arrays1, 0, result, 0, arrays1.length);
        System.arraycopy(arrays2, 0, result, arrays1.length, arrays2.length);
        System.arraycopy(arrays3, 0, result, arrays1.length + arrays2.length, arrays3.length);
        return result;
    }

    public static Map<String, Annotation[]> getPropertyAnnotation(Class<?> target) {
        LinkedHashMap<String, Annotation[]> result = new LinkedHashMap<String, Annotation[]>();
        Map<String, Property> propertyMap = BeanUtils.getPropertyFunc(target, (Method test) -> true);
        propertyMap.forEach((name, property) -> result.put((String)name, BeanUtils.getPropertyAnnotation(property)));
        return result;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> defineType) {
        ArrayList<PropertyDescriptor> mnames = new ArrayList<PropertyDescriptor>();
        List<String> ms = BeanUtils.getProperties(defineType);
        for (String m : ms) {
            try {
                mnames.add(new PropertyDescriptor(m, defineType));
            }
            catch (Exception exception) {}
        }
        return mnames.toArray(new PropertyDescriptor[0]);
    }

    public static Method getReadMethod(Class<?> target, String property) {
        if (property == null || target == null) {
            return null;
        }
        String methodName_1 = "get" + StringUtils.firstCharToUpperCase(property);
        String methodName_2 = "is" + StringUtils.firstCharToUpperCase(property);
        for (Method m : target.getMethods()) {
            Class<?> t;
            if (m.getParameterTypes().length != 0) continue;
            String methodName = m.getName();
            if (methodName.equals(methodName_1)) {
                return m;
            }
            if (!methodName.equals(methodName_2) || (t = m.getReturnType()) != Boolean.class && t != Boolean.TYPE) continue;
            return m;
        }
        return null;
    }

    public static Method getWriteMethod(Class<?> target, String property) {
        if (property == null || target == null) {
            return null;
        }
        String methodName = "set" + StringUtils.firstCharToUpperCase(property);
        for (Method m : target.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            return m;
        }
        return null;
    }

    public static Property getPropertyFunc(Class<?> target, String property) {
        Map<String, Property> propertyFunc = BeanUtils.getPropertyFunc(target, (Method test) -> test.getName().equals(property));
        return propertyFunc.get(property);
    }

    public static Map<String, Property> getPropertyFunc(Class<?> target) {
        return BeanUtils.getPropertyFunc(target, (Method test) -> true);
    }

    private static Map<String, Property> getPropertyFunc(Class<?> target, Predicate<Method> test) {
        LinkedHashMap<String, Property> propertyMap = new LinkedHashMap<String, Property>();
        Map<String, Field> allFields = BeanUtils.getALLFields(target);
        for (Method m : target.getMethods()) {
            if (m.getDeclaringClass() == Object.class || !test.test(m)) continue;
            String name = m.getName();
            if (name.startsWith("get")) {
                name = StringUtils.firstCharToLowerCase(name.substring(3));
                ((SimpleProperty)propertyMap.computeIfAbsent(name, s -> new SimpleProperty())).setReader(m);
            } else if (name.startsWith("is")) {
                name = StringUtils.firstCharToLowerCase(name.substring(2));
                ((SimpleProperty)propertyMap.computeIfAbsent(name, s -> new SimpleProperty())).setReader(m);
            } else if (name.startsWith("set")) {
                name = StringUtils.firstCharToLowerCase(name.substring(3));
                ((SimpleProperty)propertyMap.computeIfAbsent(name, s -> new SimpleProperty())).setWriter(m);
            }
            Field field = allFields.get(name);
            if (field == null) continue;
            ((SimpleProperty)propertyMap.computeIfAbsent(name, s -> new SimpleProperty())).setField(field);
        }
        return propertyMap;
    }

    public static Property getFieldFunc(Class<?> target, String property) {
        Map<String, Property> fieldFunc = BeanUtils.getFieldFunc(target, (Field test) -> test.getName().equals(property));
        return fieldFunc.get(property);
    }

    public static Map<String, Property> getFieldFunc(Class<?> target) {
        return BeanUtils.getFieldFunc(target, (Field test) -> true);
    }

    private static Map<String, Property> getFieldFunc(Class<?> target, Predicate<Field> test) {
        LinkedHashMap<String, Property> propertyMap = new LinkedHashMap<String, Property>();
        for (Field f : target.getFields()) {
            if (!test.test(f)) continue;
            ((SimpleProperty)propertyMap.computeIfAbsent(f.getName(), s -> new SimpleProperty())).setField(f);
        }
        return propertyMap;
    }

    public static boolean canReadProperty(Class<?> target, String property) {
        Method readMethod = BeanUtils.getReadMethod(target, property);
        return readMethod != null;
    }

    public static boolean canWriteProperty(Class<?> target, String property) {
        Method writeMethod = BeanUtils.getWriteMethod(target, property);
        return writeMethod != null;
    }

    public static boolean canWriteField(Class<?> target, String property) {
        Field field = BeanUtils.getField(target, property);
        return field != null && !Modifier.isFinal(field.getModifiers());
    }

    public static boolean canReadField(Class<?> target, String property) {
        return true;
    }

    public static boolean hasProperty(Class<?> target, String property) {
        if (BeanUtils.getReadMethod(target, property) == null) {
            return BeanUtils.getWriteMethod(target, property) != null;
        }
        return true;
    }

    public static boolean hasField(Class<?> target, String property) {
        return BeanUtils.getField(target, property) != null;
    }

    public static boolean writeProperty(Object object, String property, Object value) {
        if (object == null || property == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Method writeMethod = BeanUtils.getWriteMethod(defineType, property);
        if (writeMethod == null) {
            return false;
        }
        Class<?> toType = writeMethod.getParameterTypes()[0];
        Object attValueObject = ConverterUtils.convert(toType, value);
        try {
            writeMethod.invoke(object, attValueObject);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean writeField(Object object, String property, Object value) {
        if (object == null || property == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Field writeField = BeanUtils.getField(defineType, property);
        if (writeField == null) {
            return false;
        }
        Class<?> toType = writeField.getType();
        Object attValueObject = ConverterUtils.convert(toType, value);
        try {
            writeField.setAccessible(true);
            writeField.set(object, attValueObject);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object readProperty(Object object, String property) {
        if (object == null || property == null) {
            return false;
        }
        Class<?> defineType = object.getClass();
        Method readMethod = BeanUtils.getReadMethod(defineType, property);
        if (readMethod == null) {
            return null;
        }
        try {
            return readMethod.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object readField(Object object, String property) {
        if (object == null || property == null) {
            return null;
        }
        Class<?> defineType = object.getClass();
        Field readField = BeanUtils.getField(defineType, property);
        if (readField == null) {
            return null;
        }
        try {
            readField.setAccessible(true);
            return readField.get(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getPropertyType(Class<?> target, String property) {
        Property propertyFunc = BeanUtils.getPropertyFunc(target, property);
        if (propertyFunc == null) {
            return null;
        }
        return BeanUtils.getPropertyType(propertyFunc);
    }

    public static Map<String, Class<?>> getPropertyType(Class<?> target) {
        LinkedHashMap result = new LinkedHashMap();
        Map<String, Property> propertyMap = BeanUtils.getPropertyFunc(target, (Method test) -> true);
        propertyMap.forEach((name, property) -> result.put((String)name, BeanUtils.getPropertyType(property)));
        return result;
    }

    public static Class<?> getPropertyType(Property property) {
        if (property == null) {
            return null;
        }
        AccessibleObject readerHandler = ((SimpleProperty)property).getReaderHandler();
        AccessibleObject writerHandler = ((SimpleProperty)property).getWriterHandler();
        if (readerHandler instanceof Method) {
            return ((Method)readerHandler).getReturnType();
        }
        if (readerHandler instanceof Field) {
            return ((Field)readerHandler).getType();
        }
        if (writerHandler instanceof Method) {
            return ((Method)writerHandler).getParameterTypes()[0];
        }
        if (writerHandler instanceof Field) {
            return ((Field)writerHandler).getType();
        }
        return null;
    }

    public static Class<?> getFieldType(Class<?> target, String property) {
        Field readField = BeanUtils.getField(target, property);
        if (readField != null) {
            return readField.getType();
        }
        return null;
    }

    public static String toProperty(SFunction<?> property) {
        String attr;
        if (property == null) {
            return null;
        }
        Method targetMethod = MethodUtils.lambdaMethodName(property);
        if (targetMethod == null) {
            return null;
        }
        String methodName = targetMethod.getName();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            attr = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            attr = methodName.substring(2);
        } else {
            return null;
        }
        return StringUtils.firstCharToLowerCase(attr);
    }

    public static void copyProperties(Object dest, Object orig) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("orig is null");
        }
        List<Object> propNames = new ArrayList();
        if (orig instanceof Map) {
            for (Object object : ((Map)orig).keySet()) {
                propNames.add(object.toString());
            }
        } else {
            propNames = BeanUtils.getProperties(orig.getClass());
        }
        for (String string : propNames) {
            BeanUtils.copyProperty(dest, orig, string);
        }
    }

    public static void copyProperty(Object dest, Object orig, String property) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("orig is null");
        }
        if (StringUtils.isBlank(property)) {
            throw new IllegalArgumentException("property is null");
        }
        if (!(orig instanceof Map) && !BeanUtils.canReadProperty(orig.getClass(), property)) {
            return;
        }
        if (!(dest instanceof Map) && !BeanUtils.canWriteProperty(dest.getClass(), property)) {
            return;
        }
        Object val = null;
        val = !(orig instanceof Map) ? BeanUtils.readProperty(orig, property) : ((Map)orig).get(property);
        if (!(dest instanceof Map)) {
            BeanUtils.writeProperty(dest, property, val);
        } else {
            ((Map)dest).put(property, val);
        }
    }
}

