/*
 * Decompiled with CFR 0.152.
 */
package archiver;

import archiver.DeletingFileVisitor$;
import archiver.FilePermissions;
import archiver.FilePermissions$;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class IO$ {
    public static final IO$ MODULE$;

    static {
        new IO$();
    }

    public List<File> listFiles(File file, Option<String> glob) {
        Nil$ nil$;
        DirectoryStream stream;
        if (file.isDirectory()) {
            stream = (DirectoryStream)glob.map((Function1)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final DirectoryStream<Path> apply(String g) {
                    return Files.newDirectoryStream(this.file$1.toPath(), g);
                }
                {
                    this.file$1 = file$1;
                }
            }).getOrElse((Function0)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$1;

                public final DirectoryStream<Path> apply() {
                    return Files.newDirectoryStream(this.file$1.toPath());
                }
                {
                    this.file$1 = file$1;
                }
            });
            nil$ = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(stream.iterator()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final File apply(Path x$1) {
                    return x$1.toFile();
                }
            }).toList();
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
        finally {
            stream.close();
        }
    }

    public Option<String> listFiles$default$2() {
        return None$.MODULE$;
    }

    public Option<String> extension(File file) {
        return this.extension(file.getName());
    }

    public Option<String> extension(String name2) {
        int afterLastBackslash;
        String afterLastSlash = name2.substring(name2.lastIndexOf(47) + 1);
        int dotIndex = afterLastSlash.indexOf(46, afterLastBackslash = afterLastSlash.lastIndexOf(92) + 1);
        return dotIndex == -1 ? None$.MODULE$ : new Some((Object)afterLastSlash.substring(dotIndex + 1));
    }

    public void move(File src, File target) {
        Files.move(src.toPath(), target.toPath(), new CopyOption[0]);
    }

    public void copy(File file, OutputStream os) {
        Files.copy(file.toPath(), os);
    }

    public void copy(File src, File target) {
        if (src.isDirectory()) {
            this.createDirectory(target);
        } else {
            this.createDirectory(target.getParentFile());
            Files.copy(src.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    public FilePermissions getPermissions(File file) {
        return new FilePermissions((scala.collection.immutable.Set<PosixFilePermission>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])).asScala()).toSet());
    }

    public void setPermissions(File file, FilePermissions perms) {
        Files.setPosixFilePermissions(file.toPath(), (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(perms.permissions()).asJava());
    }

    public Path createDirectory(File file) {
        return Files.createDirectories(file.toPath(), new FileAttribute[0]);
    }

    public void delete(File file) {
        Files.walkFileTree(file.toPath(), DeletingFileVisitor$.MODULE$);
    }

    public void setExecutable(File file, boolean executable) {
        if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
            FilePermissions perms = this.getPermissions(file);
            FilePermissions updated = executable ? perms.add(FilePermissions$.MODULE$.exec()) : perms.remove(FilePermissions$.MODULE$.exec());
            this.setPermissions(file, perms);
        }
    }

    private IO$() {
        MODULE$ = this;
    }
}

