/*
 * Decompiled with CFR 0.152.
 */
package net.hamnaberg.schema;

import cats.data.Chain;
import cats.free.FreeApplicative;
import cats.syntax.EitherIdOps$;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.DecodingFailure$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;
import net.hamnaberg.schema.Bounds;
import net.hamnaberg.schema.Bounds$;
import net.hamnaberg.schema.Schema;
import net.hamnaberg.schema.structure;
import net.hamnaberg.schema.structure$AllOf$;
import net.hamnaberg.schema.structure$AnyOf$;
import net.hamnaberg.schema.structure$Custom$;
import net.hamnaberg.schema.structure$Defer$;
import net.hamnaberg.schema.structure$Enumeration$;
import net.hamnaberg.schema.structure$Record$;
import net.hamnaberg.schema.structure$Reference$;
import net.hamnaberg.schema.structure$SInt$;
import net.hamnaberg.schema.structure$SNum$;
import net.hamnaberg.schema.structure$Str$;
import net.hamnaberg.schema.structure$Sum$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;
import sttp.apispec.AnySchema;
import sttp.apispec.Pattern;
import sttp.apispec.SchemaLike;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Schema$
implements Serializable {
    private static final Schema int;
    private static final Schema long;
    private static final Schema bigInt;
    private static final Schema double;
    private static final Schema float;
    private static final Schema stringInstance;
    private static final Schema uuid;
    private static final Schema anything;
    private static final Schema instant;
    private static final Schema zonedDateTime;
    private static final Schema offsetDateTime;
    private static final Schema localDate;
    private static final Schema localTime;
    private static final Schema duration;
    public static final Schema$ MODULE$;

    private Schema$() {
    }

    static {
        MODULE$ = new Schema$();
        int = MODULE$.boundedInt(Bounds$.MODULE$.empty(Numeric.IntIsIntegral$.MODULE$));
        long = MODULE$.boundedLong(Bounds$.MODULE$.empty(Numeric.LongIsIntegral$.MODULE$));
        bigInt = MODULE$.boundedBigInt(Bounds$.MODULE$.empty(Numeric.BigIntIsIntegral$.MODULE$));
        double = MODULE$.boundedDouble(Bounds$.MODULE$.empty(Numeric.DoubleIsFractional$.MODULE$));
        float = MODULE$.boundedFloat(Bounds$.MODULE$.empty(Numeric.FloatIsFractional$.MODULE$));
        stringInstance = MODULE$.string(MODULE$.string$default$1(), MODULE$.string$default$2(), MODULE$.string$default$3(), MODULE$.string$default$4());
        uuid = structure$Str$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"uuid"), structure$Str$.MODULE$.$lessinit$greater$default$2(), structure$Str$.MODULE$.$lessinit$greater$default$3(), structure$Str$.MODULE$.$lessinit$greater$default$4()).xmap((Function1 & Serializable)s -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this.$init$$$anonfun$5$$anonfun$1(s)).toEither());
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)m -> DecodingFailure$.MODULE$.apply((String)Option$.MODULE$.apply((Object)m.getMessage()).getOrElse(this::$init$$$anonfun$5$$anonfun$2$$anonfun$1), this::$init$$$anonfun$5$$anonfun$2$$anonfun$2));
        }, (Function1 & Serializable)_$27 -> _$27.toString());
        anything = structure$Custom$.MODULE$.apply((SchemaLike)AnySchema.Anything$.MODULE$, Encoder$.MODULE$.apply(Encoder$.MODULE$.encodeJson()), Decoder$.MODULE$.apply(Decoder$.MODULE$.decodeJson()));
        instant = MODULE$._dateFormat(DateTimeFormatter.ISO_INSTANT, "date-time", (Function2 & Serializable)(s, _$28) -> Instant.parse(s));
        zonedDateTime = MODULE$._dateFormat(DateTimeFormatter.ISO_ZONED_DATE_TIME, "date-time", (Function2 & Serializable)(s, format) -> ZonedDateTime.parse(s, format));
        offsetDateTime = MODULE$._dateFormat(DateTimeFormatter.ISO_OFFSET_DATE_TIME, "date-time", (Function2 & Serializable)(s, format) -> OffsetDateTime.parse(s, format));
        localDate = MODULE$._dateFormat(DateTimeFormatter.ISO_LOCAL_DATE, "date", (Function2 & Serializable)(s, format) -> LocalDate.parse(s, format));
        localTime = MODULE$._dateFormat(DateTimeFormatter.ISO_LOCAL_TIME, "time", (Function2 & Serializable)(s, format) -> LocalTime.parse(s, format));
        duration = structure$Str$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"duration"), structure$Str$.MODULE$.$lessinit$greater$default$2(), structure$Str$.MODULE$.$lessinit$greater$default$3(), structure$Str$.MODULE$.$lessinit$greater$default$4()).xmap((Function1 & Serializable)s -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this.$init$$$anonfun$12$$anonfun$1(s)).toEither());
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)m -> DecodingFailure$.MODULE$.apply((String)Option$.MODULE$.apply((Object)m.getMessage()).getOrElse(() -> this.$init$$$anonfun$12$$anonfun$2$$anonfun$1(s)), this::$init$$$anonfun$12$$anonfun$2$$anonfun$2));
        }, (Function1 & Serializable)_$29 -> _$29.toString());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Schema$.class);
    }

    public <A> Schema<A> apply(Schema<A> S) {
        return S;
    }

    public Schema<Object> boundedInt(Bounds<Object> bounds) {
        return structure$SInt$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"int32"), bounds, Numeric.IntIsIntegral$.MODULE$).xmap((Function1 & Serializable)_$14 -> _$14.toInt().toRight(this::boundedInt$$anonfun$1$$anonfun$1), (Function1 & Serializable)i -> this.boundedInt$$anonfun$2(BoxesRunTime.unboxToInt((Object)i)));
    }

    public Schema<Object> boundedLong(Bounds<Object> bounds) {
        return structure$SInt$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"int64"), bounds, Numeric.LongIsIntegral$.MODULE$).xmap((Function1 & Serializable)_$15 -> _$15.toLong().toRight(this::boundedLong$$anonfun$1$$anonfun$1), (Function1 & Serializable)i -> this.boundedLong$$anonfun$2(BoxesRunTime.unboxToLong((Object)i)));
    }

    public Schema<Object> boundedDouble(Bounds<Object> bounds) {
        return structure$SNum$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"double"), bounds, Numeric.DoubleIsFractional$.MODULE$).xmap((Function1 & Serializable)_$16 -> {
            Double d = (Double)package.all$.MODULE$.catsSyntaxEitherId((Object)BoxesRunTime.boxToDouble((double)_$16.toDouble()));
            return EitherIdOps$.MODULE$.asRight$extension((Object)d);
        }, (Function1 & Serializable)i -> this.boundedDouble$$anonfun$2(BoxesRunTime.unboxToDouble((Object)i)));
    }

    public Schema<BigInt> boundedBigInt(Bounds<BigInt> bounds) {
        return structure$SInt$.MODULE$.apply((Option<String>)None$.MODULE$, bounds, Numeric.BigIntIsIntegral$.MODULE$).xmap((Function1 & Serializable)_$17 -> _$17.toBigInt().toRight(this::boundedBigInt$$anonfun$1$$anonfun$1), (Function1 & Serializable)i -> JsonNumber$.MODULE$.fromIntegralStringUnsafe(i.toString()));
    }

    public Schema<Object> boundedFloat(Bounds<Object> bounds) {
        return structure$SNum$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"float"), bounds, Numeric.FloatIsFractional$.MODULE$).xmap((Function1 & Serializable)_$18 -> {
            Float f = (Float)package.all$.MODULE$.catsSyntaxEitherId((Object)BoxesRunTime.boxToFloat((float)_$18.toFloat()));
            return EitherIdOps$.MODULE$.asRight$extension((Object)f);
        }, (Function1 & Serializable)i -> this.boundedFloat$$anonfun$2(BoxesRunTime.unboxToFloat((Object)i)));
    }

    public <R> Schema<R> fields(FreeApplicative<?, R> p) {
        return structure$Record$.MODULE$.apply(p);
    }

    public <R> Schema<R> record(Function1<Schema.FieldBuilder<R>, FreeApplicative<?, R>> b) {
        return this.fields((FreeApplicative)b.apply(this.field()));
    }

    public <A> Schema<A> defer(Function0<Schema<A>> schema) {
        return structure$Defer$.MODULE$.apply(schema);
    }

    public <A> Schema<A> custom(sttp.apispec.Schema schema, Encoder<A> encoder, Decoder<A> decoder) {
        return structure$Custom$.MODULE$.apply((SchemaLike)schema, encoder, decoder);
    }

    public Schema<Json> reference(String ref) {
        return structure$Reference$.MODULE$.apply(ref, this.any());
    }

    public Schema<Json> any() {
        return structure$Custom$.MODULE$.apply((SchemaLike)AnySchema.Anything$.MODULE$, Encoder$.MODULE$.apply(Encoder$.MODULE$.encodeJson()), Decoder$.MODULE$.apply(Decoder$.MODULE$.decodeJson()));
    }

    public <A> Schema<A> allOf(Object schemas, Option<Schema<A>> schema) {
        return structure$AllOf$.MODULE$.apply(schemas, schema);
    }

    public <A> Schema<A> anyOf(Object schemas, Option<Schema<A>> schema) {
        return structure$AnyOf$.MODULE$.apply(schemas, schema);
    }

    public <A> Schema<A> alternatives(Chain<structure.Alt<A>> cases) {
        return structure$Sum$.MODULE$.apply(cases);
    }

    public <A> Schema<A> oneOf(Function1<Schema.AltBuilder<A>, Chain<structure.Alt<A>>> b) {
        return this.alternatives((Chain)b.apply(this.alt()));
    }

    public structure.Enumeration enumeration(List<String> options) {
        return structure$Enumeration$.MODULE$.apply(options);
    }

    public <A> Schema<String> string(Option<String> format, Option<Object> minLength, Option<Object> maxLength, Option<Pattern> pattern) {
        return structure$Str$.MODULE$.apply(format, minLength, maxLength, pattern);
    }

    public <A> Option<String> string$default$1() {
        return None$.MODULE$;
    }

    public <A> Option<Object> string$default$2() {
        return None$.MODULE$;
    }

    public <A> Option<Object> string$default$3() {
        return None$.MODULE$;
    }

    public <A> Option<Pattern> string$default$4() {
        return None$.MODULE$;
    }

    public <R> Schema.FieldBuilder<R> field() {
        return new Schema.FieldBuilder();
    }

    public <R> Schema.AltBuilder<R> alt() {
        return new Schema.AltBuilder();
    }

    public Schema<Object> int() {
        return int;
    }

    public Schema<Object> long() {
        return long;
    }

    public Schema<BigInt> bigInt() {
        return bigInt;
    }

    public Schema<Object> double() {
        return double;
    }

    public Schema<Object> float() {
        return float;
    }

    public Schema<String> stringInstance() {
        return stringInstance;
    }

    public Schema<UUID> uuid() {
        return uuid;
    }

    public Schema<Json> anything() {
        return anything;
    }

    public Schema<Instant> instant() {
        return instant;
    }

    public Schema<ZonedDateTime> zonedDateTime() {
        return zonedDateTime;
    }

    public Schema<OffsetDateTime> offsetDateTime() {
        return offsetDateTime;
    }

    public Schema<LocalDate> localDate() {
        return localDate;
    }

    public Schema<LocalTime> localTime() {
        return localTime;
    }

    public Schema<Duration> duration() {
        return duration;
    }

    public <A extends TemporalAccessor> Schema<A> _dateFormat(DateTimeFormatter formatter, String typ, Function2<String, DateTimeFormatter, A> f) {
        return structure$Str$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)typ), structure$Str$.MODULE$.$lessinit$greater$default$2(), structure$Str$.MODULE$.$lessinit$greater$default$3(), structure$Str$.MODULE$.$lessinit$greater$default$4()).xmap((Function1 & Serializable)s -> {
            Either either = package.all$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> this._dateFormat$$anonfun$1$$anonfun$1(f, s, formatter)).toEither());
            return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)m -> DecodingFailure$.MODULE$.apply((String)Option$.MODULE$.apply((Object)m.getMessage()).getOrElse(() -> this._dateFormat$$anonfun$1$$anonfun$2$$anonfun$1(formatter)), this::_dateFormat$$anonfun$1$$anonfun$2$$anonfun$2));
        }, (Function1 & Serializable)b -> formatter.format((TemporalAccessor)b));
    }

    public <A> Schema<Vector<A>> unboundedVector(Schema<A> s) {
        return s.asVector(s.asVector$default$1(), s.asVector$default$2());
    }

    public <A> Schema<List<A>> unboundedList(Schema<A> s) {
        return s.asList(s.asList$default$1(), s.asList$default$2());
    }

    public <A> Schema<Seq<A>> unboundedSeq(Schema<A> s) {
        return s.asSeq(s.asSeq$default$1(), s.asSeq$default$2());
    }

    private final UUID $init$$$anonfun$5$$anonfun$1(String s$1) {
        return UUID.fromString(s$1);
    }

    private final String $init$$$anonfun$5$$anonfun$2$$anonfun$1() {
        return "Not a valid UUID";
    }

    private final List $init$$$anonfun$5$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final Duration $init$$$anonfun$12$$anonfun$1(String s$2) {
        return Duration.parse(s$2);
    }

    private final String $init$$$anonfun$12$$anonfun$2$$anonfun$1(String s$4) {
        return "Unable to parse " + s$4;
    }

    private final List $init$$$anonfun$12$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private final List boundedInt$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private final DecodingFailure boundedInt$$anonfun$1$$anonfun$1() {
        return DecodingFailure$.MODULE$.apply("Invalid int", this::boundedInt$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final /* synthetic */ JsonNumber boundedInt$$anonfun$2(int i) {
        return JsonNumber$.MODULE$.fromIntegralStringUnsafe(BoxesRunTime.boxToInteger((int)i).toString());
    }

    private final List boundedLong$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private final DecodingFailure boundedLong$$anonfun$1$$anonfun$1() {
        return DecodingFailure$.MODULE$.apply("Invalid long", this::boundedLong$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final /* synthetic */ JsonNumber boundedLong$$anonfun$2(long i) {
        return JsonNumber$.MODULE$.fromIntegralStringUnsafe(BoxesRunTime.boxToLong((long)i).toString());
    }

    private final /* synthetic */ JsonNumber boundedDouble$$anonfun$2(double i) {
        return JsonNumber$.MODULE$.fromDecimalStringUnsafe(BoxesRunTime.boxToDouble((double)i).toString());
    }

    private final List boundedBigInt$$anonfun$1$$anonfun$1$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private final DecodingFailure boundedBigInt$$anonfun$1$$anonfun$1() {
        return DecodingFailure$.MODULE$.apply("Invalid bigint", this::boundedBigInt$$anonfun$1$$anonfun$1$$anonfun$1);
    }

    private final /* synthetic */ JsonNumber boundedFloat$$anonfun$2(float i) {
        return JsonNumber$.MODULE$.fromDecimalStringUnsafe(BoxesRunTime.boxToFloat((float)i).toString());
    }

    private final TemporalAccessor _dateFormat$$anonfun$1$$anonfun$1(Function2 f$4, String s$5, DateTimeFormatter formatter$2) {
        return (TemporalAccessor)f$4.apply((Object)s$5, (Object)formatter$2);
    }

    private final String _dateFormat$$anonfun$1$$anonfun$2$$anonfun$1(DateTimeFormatter formatter$4) {
        return "Does not parse from " + formatter$4.toFormat();
    }

    private final List _dateFormat$$anonfun$1$$anonfun$2$$anonfun$2() {
        return package$.MODULE$.Nil();
    }
}

