/*
 * Decompiled with CFR 0.152.
 */
package net.haesleinhuepf.clijx.imagej3dsuite;

import ij.ImagePlus;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageLabeller;
import net.haesleinhuepf.clij.clearcl.ClearCLBuffer;
import net.haesleinhuepf.clij.clearcl.interfaces.ClearCLImageInterface;
import net.haesleinhuepf.clij.coremem.enums.NativeTypeEnum;
import net.haesleinhuepf.clij.macro.CLIJMacroPlugin;
import net.haesleinhuepf.clij.macro.CLIJOpenCLProcessor;
import net.haesleinhuepf.clij.macro.documentation.OffersDocumentation;
import net.haesleinhuepf.clij2.AbstractCLIJ2Plugin;
import net.haesleinhuepf.clij2.CLIJ2;
import net.haesleinhuepf.clij2.utilities.HasClassifiedInputOutput;
import net.haesleinhuepf.clij2.utilities.IsCategorized;
import org.scijava.plugin.Plugin;

@Plugin(type=CLIJMacroPlugin.class, name="CLIJx_imageJ3DSuiteConnectedComponentsLabeling")
public class ImageJ3DSuiteConnectedComponentsLabeling
extends AbstractCLIJ2Plugin
implements CLIJMacroPlugin,
CLIJOpenCLProcessor,
OffersDocumentation,
IsCategorized,
HasClassifiedInputOutput {
    public String getParameterHelpText() {
        return "Image input, ByRef Image destination";
    }

    public boolean executeCL() {
        boolean result = ImageJ3DSuiteConnectedComponentsLabeling.imageJ3DSuiteConnectedComponentsLabeling(this.getCLIJ2(), (ClearCLBuffer)this.args[0], (ClearCLBuffer)this.args[1]);
        return result;
    }

    public static boolean imageJ3DSuiteConnectedComponentsLabeling(CLIJ2 clij2, ClearCLBuffer input1, ClearCLBuffer output) {
        ImagePlus input = clij2.pullBinary(input1);
        ImageHandler ima1 = ImageHandler.wrap((ImagePlus)input);
        ImageByte ima2 = ima1.threshold(128.0f, false, false);
        ImageLabeller labels = new ImageLabeller();
        ImageFloat seg = labels.getLabelsFloat((ImageHandler)ima2);
        ImagePlus result_imp = seg.getImagePlus();
        ClearCLBuffer result_buffer = clij2.push((Object)result_imp);
        clij2.copy((ClearCLImageInterface)result_buffer, (ClearCLImageInterface)output);
        result_buffer.close();
        return true;
    }

    public String getDescription() {
        return "Apply ImageJ 3D Suite Connected Components Labeling (Segment 3D) to an image in 3D.";
    }

    public String getAvailableForDimensions() {
        return "3D";
    }

    public String getCategories() {
        return "Labeling";
    }

    public static void main(String[] args) {
        CLIJ2 clij2 = CLIJ2.getInstance();
        ClearCLBuffer input = clij2.pushString("0 0 0 1\n1 0 0 1\n\n1 1 0 1\n1 1 0 0");
        ClearCLBuffer output = clij2.create(input);
        ImageJ3DSuiteConnectedComponentsLabeling.imageJ3DSuiteConnectedComponentsLabeling(clij2, input, output);
        clij2.print((ClearCLImageInterface)output);
    }

    public String getInputType() {
        return "Binary Image";
    }

    public String getOutputType() {
        return "Label Image";
    }

    public ClearCLBuffer createOutputBufferFromSource(ClearCLBuffer input) {
        return this.clij.create(input.getDimensions(), NativeTypeEnum.Float);
    }
}

